<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\User; // User মডেলটি ইম্পোর্ট করা হয়েছে

class Deposit extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_id',
        'amount',
        'trx',
        'status',
        'method_name',
        'date',
    ];

    /**
     * Get the user that owns the deposit.
     * এই ফাংশনটি Deposit-এর সাথে User-এর সম্পর্ক স্থাপন করে।
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
