<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="mobile-web-app-capable" content="yes">
    <title>{{ env('APP_NAME') }} | Register</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" type="image/png" href="{{ asset('static/images/logo.jpg') }}">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Sora:wght@300;400;500;600;700;800&display=swap');
        
        * {
            font-family: 'Sora', sans-serif;
            -webkit-tap-highlight-color: transparent;
        }
        
        html, body {
            height: 100%; 
            height: 100vh;
            height: 100dvh;
            margin: 0;
            padding: 0;
            overflow: hidden;
        }
        
        body {
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%);
            position: fixed;
            width: 100%;
            color: #1e293b;
        }
        
        .main-wrapper {
            height: 100vh;
            height: 100dvh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            overflow: hidden;
        }
        
        /* Animated Background Elements */
        .bg-elements {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 0;
            pointer-events: none;
            overflow: hidden;
        }
        
        .bg-element {
            position: absolute;
            border-radius: 50%;
            opacity: 0.05;
            animation: float 20s ease-in-out infinite;
        }
        
        .bg-element-1 {
            width: 300px;
            height: 300px;
            background: linear-gradient(135deg, #3b82f6, #8b5cf6);
            top: -100px;
            left: -100px;
        }
        
        .bg-element-2 {
            width: 250px;
            height: 250px;
            background: linear-gradient(135deg, #ec4899, #f59e0b);
            bottom: -50px;
            right: -50px;
            animation-delay: 5s;
        }
        
        @keyframes float {
            0%, 100% { transform: translate(0, 0) scale(1); }
            50% { transform: translate(30px, 30px) scale(1.1); }
        }
        
        .register-container {
            width: 100%;
            max-width: 500px;
            background: white;
            border-radius: 24px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
            padding: 40px 30px;
            animation: slideUp 0.7s cubic-bezier(0.34, 1.56, 0.64, 1);
            position: relative;
            z-index: 10;
            max-height: 95vh;
            overflow-y: auto;
        }
        
        @keyframes slideUp {
            from { opacity: 0; transform: translateY(40px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .logo-section {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo-icon {
            width: 60px;
            height: 60px;
            margin: 0 auto 15px;
            background: linear-gradient(135deg, #3b82f6 0%, #8b5cf6 100%);
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 30px;
            color: white;
            font-weight: 700;
            box-shadow: 0 10px 20px rgba(59, 130, 246, 0.2);
            overflow: hidden; /* Ensures the image fits within the rounded corners */
        }

        .logo-icon img {
            width: 100%;
            height: 100%;
            object-fit: cover; /* Ensures the image covers the area without distortion */
        }
        
        .header-title {
            font-size: 28px;
            font-weight: 800;
            color: #0f172a;
            margin: 0 0 5px 0;
            letter-spacing: -0.5px;
        }
        
        .header-subtitle {
            font-size: 14px;
            color: #64748b;
            margin: 0;
        }
        
        .form-group {
            margin-bottom: 18px;
        }
        
        .form-label {
            display: block;
            font-size: 12px;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 8px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .input-wrapper {
            position: relative;
            display: flex;
            align-items: center;
        }
        
        .input-icon {
            position: absolute;
            left: 14px;
            top: 50%;
            transform: translateY(-50%);
            color: #94a3b8;
            font-size: 16px;
            z-index: 5;
            transition: all 0.3s ease;
        }
        
        .input-field {
            width: 100%;
            padding: 13px 16px 13px 48px;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 15px;
            font-weight: 500;
            color: #0f172a;
            background: #f8fafc;
            transition: all 0.3s ease;
            outline: none;
        }
        
        .input-field:focus {
            border-color: #3b82f6;
            background: white;
            box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.1);
        }
        
        .input-field-phone {
            padding-left: 85px;
        }
        
        .phone-prefix {
            position: absolute;
            left: 48px;
            top: 50%;
            transform: translateY(-50%);
            color: #1e293b;
            font-weight: 700;
            font-size: 14px;
            z-index: 5;
        }
        
        .password-toggle {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #94a3b8;
            cursor: pointer;
            padding: 8px;
            z-index: 5;
        }
        
        .submit-btn {
            width: 100%;
            padding: 14px;
            margin-top: 20px;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 700;
            color: white;
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 10px 20px rgba(59, 130, 246, 0.2);
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .submit-btn:hover:not(:disabled) {
            transform: translateY(-2px);
            box-shadow: 0 15px 30px rgba(59, 130, 246, 0.3);
        }
        
        .submit-btn:disabled {
            opacity: 0.7;
            cursor: not-allowed;
        }
        
        .divider {
            display: flex;
            align-items: center;
            margin: 25px 0;
            gap: 10px;
        }
        
        .divider-line {
            flex: 1;
            height: 1px;
            background: #e2e8f0;
        }
        
        .divider-text {
            font-size: 11px;
            color: #94a3b8;
            font-weight: 700;
            text-transform: uppercase;
        }
        
        .login-link-section {
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            border-radius: 12px;
            padding: 15px;
            text-align: center;
        }
        
        .login-text {
            font-size: 14px;
            color: #475569;
            margin: 0;
        }
        
        .login-link {
            color: #3b82f6;
            font-weight: 700;
            text-decoration: none;
            margin-left: 5px;
        }
        
        .error-text {
            font-size: 12px;
            color: #dc2626;
            margin-top: 5px;
            font-weight: 600;
        }
        
        .spinner {
            display: inline-block;
            width: 18px;
            height: 18px;
            border: 3px solid rgba(255, 255, 255, 0.3);
            border-top-color: white;
            border-radius: 50%;
            animation: spin 0.8s linear infinite;
        }
        
        @keyframes spin { to { transform: rotate(360deg); } }
        
        @media (max-width: 480px) {
            .register-container { padding: 30px 20px; }
            .header-title { font-size: 24px; }
            .input-field { font-size: 14px; padding: 12px 14px 12px 44px; }
            .phone-prefix { left: 44px; }
            .input-icon { left: 12px; }
        }
    </style>
</head>
<body>
    
    <div class="bg-elements">
        <div class="bg-element bg-element-1"></div>
        <div class="bg-element bg-element-2"></div>
    </div>
    
    <div class="main-wrapper">
        <div class="register-container">
            
            <div class="logo-section">
                <div class="logo-icon">
                    <a href="{{ url('/') }}">
                        <img src="https://i.postimg.cc/qMX2HKS6/IMG-20260121-WA0002.jpg" alt="Logo">
                    </a>
                </div>
                <h1 class="header-title">Create Account</h1>
                <p class="header-subtitle">Join us and start your journey today</p>
            </div>
            
            <form id="registerForm" action="{{ url('register') }}" method="post" autocomplete="off">
                @csrf
                
                <!-- Phone Number -->
                <div class="form-group">
                    <label class="form-label">Phone Number</label>
                    <div class="input-wrapper">
                        <i class="fas fa-phone input-icon"></i>
                        <input 
                            type="number" 
                            class="input-field input-field-phone" 
                            id="phone" 
                            name="phone" 
                            required
                        >
                    </div>
                    @error('phone')
                        <p class="error-text">{{ $message }}</p>
                    @enderror
                </div>
                
                <!-- Password -->
                <div class="form-group">
                    <label class="form-label">Password</label>
                    <div class="input-wrapper">
                        <i class="fas fa-lock input-icon"></i>
                        <input 
                            type="password" 
                            class="input-field" 
                            id="password" 
                            name="password" 
                            placeholder="Create a secure password" 
                            required
                        >
                        <button type="button" class="password-toggle" onclick="togglePasswordVisibility()">
                            <i class="fas fa-eye-slash" id="toggleIcon"></i>
                        </button>
                    </div>
                    @error('password')
                        <p class="error-text">{{ $message }}</p>
                    @enderror
                </div>
                
                <!-- Invitation Code -->
                <div class="form-group">
                    <label class="form-label">Invitation Code (Optional)</label>
                    <div class="input-wrapper">
                        <i class="fas fa-gift input-icon"></i>
                        <input 
                            type="text" 
                            class="input-field" 
                            name="ref_id" 
                            placeholder="Enter code" 
                            value="{{ $ref_by ?? '' }}"
                        >
                    </div>
                </div>
                
                <div id="errorMessage" class="error-text text-center mb-4" style="display: none;"></div>
                
                <button type="submit" class="submit-btn">
                    <span class="flex items-center justify-center">
                        <i class="fas fa-user-plus mr-2"></i>
                        Create Account
                    </span>
                </button>
            </form>
            
            <div class="divider">
                <div class="divider-line"></div>
                <span class="divider-text">Already a member?</span>
                <div class="divider-line"></div>
            </div>
            
            <div class="login-link-section">
                <p class="login-text">
                    Already have an account? 
                    <a href="{{ url('login') }}" class="login-link">Login here</a>
                </p>
            </div>
            
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script>
        toastr.options = { "closeButton": true, "progressBar": true, "positionClass": "toast-top-right" };

        @if(session('error')) toastr.error("{{ session('error') }}"); @endif
        @if($errors->any())
            @foreach ($errors->all() as $error) toastr.error("{{ $error }}"); @endforeach
        @endif

        function togglePasswordVisibility() {
            const passwordInput = document.getElementById('password');
            const icon = document.getElementById('toggleIcon');
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                icon.classList.replace('fa-eye-slash', 'fa-eye');
            } else {
                passwordInput.type = 'password';
                icon.classList.replace('fa-eye', 'fa-eye-slash');
            }
        }

        document.getElementById('registerForm').addEventListener('submit', function(event) {
            const phone = document.getElementById('phone').value;
            const password = document.getElementById('password').value;
            const errorMessage = document.getElementById('errorMessage');
            const submitBtn = this.querySelector('button[type="submit"]');

            if (!phone || !password) {
                event.preventDefault();
                errorMessage.textContent = 'Please fill out all required fields.';
                errorMessage.style.display = 'block';
                return;
            }

            submitBtn.innerHTML = '<span class="flex items-center justify-center"><span class="spinner mr-2"></span>Creating Account...</span>';
            submitBtn.disabled = true;
        });
    </script>
</body>
</html>