<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>About trust wallet</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
    :root {
      --brand-primary: #e60012;
      --brand-dark: #b3000e;
      --text-muted: #6b7280;
      --card-shadow: 0 8px 25px rgba(179, 0, 14, 0.08);
    }

    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      background: linear-gradient(135deg, #f8fafc 0%, #e7e9ef 100%);
      min-height: 100vh;
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
      -webkit-font-smoothing: antialiased;
      position: relative;
    }

    body::before {
      content: '';
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      height: 280px;
      background: linear-gradient(135deg, var(--brand-primary) 0%, var(--brand-dark) 100%);
      z-index: 0;
    }

    /* Header */
    .page-header {
      background: transparent;
      color: #fff;
      padding: 0 20px;
      height: 60px;
      font-size: 20px;
      font-weight: 700;
      position: relative;
      z-index: 1000;
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    .back-arrow {
      color: #fff;
      font-size: 22px;
      text-decoration: none;
      width: 32px;
      height: 32px;
      display: flex;
      align-items: center;
      justify-content: center;
      border-radius: 8px;
      transition: all 0.3s ease;
      background: rgba(255, 255, 255, 0.1);
      backdrop-filter: blur(10px);
      cursor: pointer;
      border: none;
    }

    .back-arrow:hover {
      background: rgba(255, 255, 255, 0.2);
      transform: translateX(-3px);
    }
    
    .header-placeholder {
      width: 32px;
      height: 32px;
      display: flex;
      align-items: center;
      justify-content: center;
      color: #fff;
      font-size: 22px;
    }

    .header-title {
      display: flex;
      align-items: center;
      gap: 10px;
    }

    .header-icon {
      width: 36px;
      height: 36px;
      background: rgba(255, 255, 255, 0.15);
      border-radius: 10px;
      display: flex;
      align-items: center;
      justify-content: center;
      backdrop-filter: blur(10px);
    }

    /* Content */
    .content-box {
      padding: 20px;
      position: relative;
      z-index: 1;
      max-width: 520px;
      margin: 0 auto;
    }

    /* Card */
    .card {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(20px);
      border-radius: 18px;
      padding: 22px;
      margin-bottom: 18px;
      border: 1px solid rgba(255, 255, 255, 0.8);
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
      position: relative;
      overflow: hidden;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 4px;
      background: linear-gradient(90deg, var(--brand-primary), var(--brand-dark));
    }

    .card:hover {
      transform: translateY(-4px);
      box-shadow: 0 15px 50px rgba(0, 0, 0, 0.12);
    }

    /* Section Headers */
    h2, h3 {
      margin: 0 0 16px;
      font-size: 18px;
      display: flex;
      align-items: center;
      gap: 10px;
      color: #1f2937;
      font-weight: 700;
    }

    .section-icon {
      width: 40px;
      height: 40px;
      background: linear-gradient(135deg, rgba(230, 0, 18, 0.1), rgba(179, 0, 14, 0.05));
      border-radius: 10px;
      display: flex;
      align-items: center;
      justify-content: center;
      color: var(--brand-primary);
      font-size: 18px;
      flex-shrink: 0;
    }

    p {
      font-size: 15px;
      line-height: 1.7;
      color: #4b5563;
      margin-bottom: 0;
      font-weight: 500;
    }

    p b {
      color: #1f2937;
      font-weight: 700;
    }

    ul {
      list-style: none;
      padding: 0;
      margin: 0;
    }

    li {
      font-size: 15px;
      line-height: 1.7;
      color: #4b5563;
      margin-bottom: 12px;
      padding-left: 32px;
      position: relative;
      font-weight: 500;
    }

    li:last-child {
      margin-bottom: 0;
    }

    li::before {
      content: '\f058';
      font-family: 'Font Awesome 6 Free';
      font-weight: 900;
      position: absolute;
      left: 0;
      color: var(--brand-primary);
      font-size: 16px;
    }

    /* Banner Image */
    img.banner {
      width: 100%;
      border-radius: 14px;
      margin: 16px 0 0;
      box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
      transition: all 0.3s ease;
    }

    img.banner:hover {
      transform: scale(1.02);
      box-shadow: 0 12px 32px rgba(0, 0, 0, 0.2);
    }

    /* Highlight Pill */
    .pill {
      display: inline-flex;
      align-items: center;
      padding: 6px 14px;
      border-radius: 999px;
      background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
      color: #fff;
      font-size: 13px;
      font-weight: 700;
      margin: 0 4px;
      box-shadow: 0 4px 12px rgba(230, 0, 18, 0.25);
    }

    /* Intro Card Special Styling */
    .intro-card {
      background: linear-gradient(135deg, rgba(255, 255, 255, 0.98), rgba(255, 255, 255, 0.95));
    }

    .intro-card::before {
      height: 5px;
    }

    /* Stats Grid */
    .stats-text {
      display: flex;
      align-items: center;
      gap: 8px;
      flex-wrap: wrap;
      font-size: 15px;
      line-height: 1.7;
      color: #4b5563;
    }

    /* Animation */
    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .card {
      animation: fadeInUp 0.5s ease-out backwards;
    }

    .card:nth-child(1) { animation-delay: 0.1s; }
    .card:nth-child(2) { animation-delay: 0.2s; }
    .card:nth-child(3) { animation-delay: 0.3s; }
    .card:nth-child(4) { animation-delay: 0.4s; }
    .card:nth-child(5) { animation-delay: 0.5s; }

    /* Responsive */
    @media (max-width: 480px) {
      .content-box {
        padding: 16px;
      }

      .card {
        padding: 18px;
        margin-bottom: 14px;
      }

      h2, h3 {
        font-size: 16px;
      }

      p, li {
        font-size: 14px;
      }

      .section-icon {
        width: 36px;
        height: 36px;
        font-size: 16px;
      }
    }
  </style>
</head>
<body>

  <!-- Header -->
  <div class="page-header">
    <button class="back-arrow" onclick="history.back()">
      <i class="fas fa-arrow-left"></i>
    </button>
    <div class="header-title">
      <div class="header-icon">
        <i class="fas fa-car"></i>
      </div>
      <span>About trust wallet</span>
    </div>
    <div class="header-placeholder">
      <i class="fas fa-car-side"></i>
    </div>
  </div>

  <!-- Content -->
  <div class="content-box">

    <!-- Intro -->
    <div class="card intro-card">
      <h2>
        <div class="section-icon">
          <i class="fas fa-info-circle"></i>
        </div>
        trust wallet
      </h2>
      <p>The <b>trust wallet</b> is a global icon of style, efficiency, and performance. For over 50 years, it has redefined driving with cutting-edge technology and reliability trusted worldwide.</p>
      <img src="/ui1/4.png" class="banner" alt="trust wallet Banner" />
    </div>

    <!-- Performance -->
    <div class="card">
      <h3>
        <div class="section-icon">
          <i class="fas fa-gauge-high"></i>
        </div>
        Performance
      </h3>
      <ul>
        <li>Turbocharged engine options for power & efficiency</li>
        <li>Sport-tuned suspension for smoother handling</li>
        <li>Eco-assist for fuel savings</li>
      </ul>
    </div>

    <!-- Safety -->
    <div class="card">
      <h3>
        <div class="section-icon">
          <i class="fas fa-shield-halved"></i>
        </div>
        Safety First
      </h3>
      <ul>
        <li>trust wallet Sensing® safety suite</li>
        <li>Adaptive Cruise Control & Collision Mitigation</li>
        <li>Lane Keeping Assist & Road Departure Mitigation</li>
      </ul>
    </div>

    <!-- Interior -->
    <div class="card">
      <h3>
        <div class="section-icon">
          <i class="fas fa-tv"></i>
        </div>
        Interior & Technology
      </h3>
      <ul>
        <li>Spacious & premium interiors</li>
        <li>10.2" Digital Display & Touchscreen Infotainment</li>
        <li>Apple CarPlay® & Android Auto™</li>
      </ul>
    </div>

    <!-- Legacy -->
    <div class="card">
      <h3>
        <div class="section-icon">
          <i class="fas fa-globe"></i>
        </div>
        Global Legacy
      </h3>
      <div class="stats-text">
        <span>The Civic has sold</span>
        <span class="pill"><i class="fas fa-trophy"></i>&nbsp;&nbsp;27M+</span>
        <span>units in</span>
        <span class="pill"><i class="fas fa-flag"></i>&nbsp;&nbsp;170+</span>
        <span>countries, making it one of the most trusted and loved sedans worldwide.</span>
      </div>
    </div>

  </div>

</body>
</html>