<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    
    <title>{{ env('APP_NAME') }} | Dashboard</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" type="image/jpg" href="{{ asset('static/images/logo.jpg') }}">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'sans-serif'],
                        'poppins': ['Poppins', 'sans-serif'],
                    }
                }
            }
        }
    </script>

    <style>
        html { -webkit-text-size-adjust: 100%; }
        body { margin: 0; font-family: 'Inter', sans-serif; background-color: white; }
        .main-container { max-width: 480px; margin: 0 auto; background-color: white; min-height: 100vh; position: relative; overflow: hidden; }
        .content-wrapper { padding-bottom: 100px; }
        
        @keyframes fadeIn { from { opacity: 0; transform: translateY(10px); } to { opacity: 1; transform: translateY(0); } }
        .page-transition { animation: fadeIn 0.5s ease-out; }
        
        .bottom-nav { position: fixed; bottom: 0; left: 0; right: 0; max-width: 480px; margin: 0 auto; height: 80px; z-index: 1000; }
        .nav-item.active .active-indicator { opacity: 1; transform: translateY(0); }
        .active-indicator { position: absolute; bottom: 0; left: 50%; transform: translateX(-50%) translateY(3px); width: 60%; height: 3px; background: linear-gradient(90deg, #dc2626, #ef4444); border-radius: 3px 3px 0 0; box-shadow: 0 0 10px rgba(220, 38, 38, 0.5); opacity: 0; transition: all 0.3s ease; }
        .action-button:hover { transform: translateY(-2px); box-shadow: 0 8px 20px rgba(0,0,0,0.15); }
        .no-underline { text-decoration: none !important; }
    </style>
</head>
<body class="page-transition">
    
    <?php
        use App\Models\Purchase;
        $active_investments = Purchase::where('user_id', auth()->id())->where('status', 'active')->with('package')->get();
    ?>

    <div class="main-container">
        
        <!-- Header -->
        <header class="bg-white px-4 py-4 flex items-center justify-between shadow-sm sticky top-0 z-50">
            <div class="flex items-center space-x-2">
                <div class="w-10 h-10 bg-red-600 rounded-full flex items-center justify-center overflow-hidden">
                    <a href="{{ url('dashboard') }}" class="w-full h-full">
                        <img src="https://i.postimg.cc/qMX2HKS6/IMG-20260121-WA0002.jpg" alt="Logo" class="w-full h-full object-cover">
                    </a>
                </div> 
                <div class="flex flex-col">
                    <span class="text-red-600 font-bold text-base leading-tight">Trust Wallet Official </span>
                    <span class="text-gray-500 text-[10px] leading-tight">INDUSTRIES LIMITED</span>
                </div>
            </div>
            <button class="text-gray-400 text-2xl"><i class="far fa-bell"></i></button>
        </header>

        <main class="content-wrapper">
            <!-- Static Banner Image (As per Nova design) -->
            <div class="px-4 py-4">
                <div class="bg-gradient-to-r from-red-600 to-red-500 rounded-2xl overflow-hidden shadow-lg relative h-40">
                    <img src="https://images.unsplash.com/photo-1509391366360-2e959784a276?w=800&auto=format&fit=crop&q=60" alt="Solar Panel Banner" class="absolute inset-0 w-full h-full object-cover opacity-30">
                    <div class="relative z-10 p-4 h-full flex flex-col justify-between">
                        <div class="flex justify-between items-start">
                            <div class="text-white">
                                <p class="text-[10px] uppercase tracking-wide mb-1">First Time</p>
                                <p class="text-xs font-semibold">AMERICA AUTO ELECTRICALS</p>
                            </div>
                            <div class="bg-white text-red-600 font-bold text-xl px-4 py-1 rounded shadow-md">
                                Trust Wallet
                            </div>
                        </div>
                        <div class="flex justify-between items-end">
                            <div class="bg-white/20 backdrop-blur-sm rounded-lg px-3 py-1">
                                <p class="text-white text-[10px]">Solar Panel</p>
                            </div>
                        </div>
                    </div> 
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="px-4 py-3">
                <div class="grid grid-cols-4 gap-3">
                    @php
                        $actions = [
                            ['url' => url('my-team'), 'icon' => 'fas fa-calendar-check', 'label' => 'Invite', 'bg' => 'from-orange-400 to-orange-500'],
                            ['url' => url('/service'), 'icon' => 'fas fa-headphones', 'label' => 'support', 'bg' => 'from-indigo-500 to-blue-500'],
                            ['url' => url('user/recharge'), 'icon' => 'fas fa-wallet', 'label' => 'Deposit', 'bg' => 'from-pink-400 to-pink-500'],
                            ['url' => url('withdraw'), 'icon' => 'fas fa-hand-holding-usd', 'label' => 'Withdraw', 'bg' => 'from-cyan-400 to-blue-400'],
                        ];
                    @endphp
                    @foreach($actions as $action)
                    <div class="flex flex-col items-center">
                        <a href="{{ $action['url'] }}" @if($action['label'] == 'Group') target="_blank" @endif class="no-underline action-button">
                            <div class="w-16 h-16 bg-gradient-to-br {{ $action['bg'] }} rounded-full flex items-center justify-center shadow-lg mb-2 hover:scale-105 transition-transform cursor-pointer">
                                <i class="{{ $action['icon'] }} text-white text-2xl"></i>
                            </div>
                        </a>
                        <span class="text-gray-600 text-xs font-medium">{{ $action['label'] }}</span>
                    </div>
                    @endforeach
                </div>
            </div>

            <!-- Complete Tasks Banner -->
            <div class="px-4 py-3">
                <div class="bg-gradient-to-r from-red-400 via-orange-400 to-red-400 rounded-2xl p-5 relative overflow-hidden shadow-lg">
                    <div class="relative z-10">
                        <div class="flex items-center justify-center mb-3">
                            <i class="fas fa-trophy text-yellow-300 text-4xl mr-3"></i>
                            <span class="text-white font-bold text-base">Complete tasks to get rewards</span>
                        </div>
                        <div class="flex justify-center">
                            <a href="{{ url('vip') }}" class="no-underline">
                                <button class="bg-gradient-to-r from-yellow-300 to-yellow-400 text-gray-900 font-bold px-8 py-2.5 rounded-full text-sm shadow-lg hover:shadow-xl transition-all hover:scale-105">
                                    To Complete >
                                </button>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Active Investments Section -->
            @if($active_investments->isEmpty())
                <div class="px-4 py-3">
                    <div class="bg-gray-50 rounded-2xl p-6 text-center">
                        <i class="fas fa-inbox text-gray-300 text-5xl mb-3"></i>
                        <p class="text-gray-500 font-medium mb-2">No Active Investments</p>
                        <p class="text-gray-400 text-sm mb-4">Start investing to earn daily profits</p>
                        <a href="{{ url('vip') }}" class="inline-block bg-red-600 text-white px-6 py-2.5 rounded-full font-semibold hover:bg-red-700 transition">
                            View Plans
                        </a>
                    </div>
                </div>
            @else
                <div class="px-4 pt-3">
                    <h3 class="text-base font-bold text-gray-800 mb-3 px-1">Your Active Investments</h3>
                    @foreach($active_investments as $investment)
                        <div class="bg-white rounded-2xl p-4 shadow-md border border-gray-100 mb-3">
                            <div class="flex justify-between items-center">
                                <div>
                                    <p class="font-bold text-gray-800">{{ $investment->package->name ?? 'N/A' }}</p>
                                    <p class="text-xs text-gray-500">Amount: ৳ {{ number_format($investment->package->price ?? 0, 2) }}</p>
                                </div>
                                <div class="text-right">
                                    <p class="font-semibold text-green-600 text-sm">+ ৳ {{ number_format($investment->package->daily_limit ?? 0, 2) }}</p>
                                    <p class="text-xs text-gray-500">Daily</p>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </main>
    </div>

    <!-- Bottom Navigation -->
    <nav class="bottom-nav bg-gradient-to-t from-white via-white to-white/95 backdrop-blur-lg shadow-[0_-8px_32px_rgba(0,0,0,0.12)] border-t border-red-100">
        <div class="flex justify-around items-center w-full h-full">
            @php
                $nav_items = [
                    ['path' => 'dashboard', 'icon' => 'fas fa-home', 'label' => 'Home'],
                    ['path' => 'vip', 'icon' => 'fas fa-briefcase', 'label' => 'Plans'],
                    ['path' => 'my-team', 'icon' => 'fas fa-users', 'label' => 'Team'],
                    ['path' => 'my-profile', 'icon' => 'fas fa-user', 'label' => 'Profile'],
                ];
            @endphp
            @foreach($nav_items as $item)
            <a href="{{ url($item['path']) }}" class="nav-item flex-1 flex flex-col items-center justify-center relative rounded-2xl text-gray-500 hover:text-red-500 transition-all duration-300 {{ request()->is($item['path']) ? 'text-red-600 bg-red-50 active' : '' }}">
                <div class="relative">
                    <i class="{{ $item['icon'] }} text-xl mb-1"></i>
                    @if(request()->is($item['path']))
                        <div class="active-indicator"></div>
                    @endif
                </div>
                <span class="font-poppins text-[10px] font-semibold tracking-wide">{{ $item['label'] }}</span>
            </a>
            @endforeach
        </div>
    </nav>

    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            toastr.options = { "closeButton": true, "progressBar": true, "positionClass": "toast-top-right" };
            @if(session('success'))
                toastr.success("{{ session('success') }}");
            @endif
            @if(session('error'))
                toastr.error("{{ session('error') }}");
            @endif
        });
    </script>
</body>
</html>