<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#e60012">

    <title>Help Center — {{ env('APP_NAME') }}</title>
    
    <link rel="icon" type="image/jpg" href="{{ asset('static/images/logo.jpg') }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">

    <!-- Start of LiveChat (www.livechat.com) code -->
    <script>
        window.__lc = window.__lc || {};
        window.__lc.license = 19466069;
        window.__lc.integration_name = "manual_channels";
        window.__lc.product_name = "livechat";
        ;(function(n,t,c){function i(n){return e._h?e._h.apply(null,n):e._q.push(n)}var e={_q:[],_h:null,_v:"2.0",on:function(){i(["on",c.call(arguments)])},once:function(){i(["once",c.call(arguments)])},off:function(){i(["off",c.call(arguments)])},get:function(){if(!e._h)throw new Error("[LiveChatWidget] You can't use getters before load.");return i(["get",c.call(arguments)])},call:function(){i(["call",c.call(arguments)])},init:function(){var n=t.createElement("script");n.async=!0,n.type="text/javascript",n.src="https://cdn.livechatinc.com/tracking.js",t.head.appendChild(n)}};!n.__lc.asyncInit&&e.init(),n.LiveChatWidget=n.LiveChatWidget||e}(window,document,[].slice))
    </script>
    <noscript><a href="https://www.livechat.com/chat-with/19466069/" rel="nofollow">Chat with us</a>, powered by <a href="https://www.livechat.com/?welcome" rel="noopener nofollow" target="_blank">LiveChat</a></noscript>
    <!-- End of LiveChat code -->

    <style>
        :root {
            --brand-primary: #e60012;
            --brand-dark: #b3000e;
            --text-muted: #6b7280;
        }
        html { -webkit-text-size-adjust: 100%; }
        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e7e9ef 100%);
            min-height: 100vh;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            position: relative;
            margin: 0;
        }
        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 200px;
            background: linear-gradient(135deg, var(--brand-primary) 0%, var(--brand-dark) 100%);
            z-index: 0;
        }
        .main-container {
            max-width: 500px;
            margin: 0 auto;
            position: relative;
            z-index: 1;
            min-height: 100vh;
            padding-bottom: 100px;
        }
        .page-header {
            background: transparent;
            padding: 16px 20px;
            display: flex;
            align-items: center; 
            justify-content: space-between;
        }
        .header-title { color: #fff; font-weight: 700; font-size: 18px; }
        .header-placeholder { width: 40px; }
        .back-btn {
            width: 40px; height: 40px;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: none; border-radius: 10px;
            color: #fff; font-size: 20px;
            cursor: pointer; transition: all 0.3s ease;
            display: flex; align-items: center; justify-content: center;
            text-decoration: none;
        }
        .content-wrapper { padding: 20px; display: flex; flex-direction: column; gap: 16px; }
        .help-card {
            display: flex;
            align-items: center;
            gap: 16px;
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 18px;
            padding: 20px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.8);
            text-decoration: none;
            color: inherit;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        .help-card:hover {
            transform: translateY(-4px) scale(1.02);
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.15);
        }
        .help-icon {
            width: 50px; height: 50px;
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            font-size: 22px;
            flex-shrink: 0;
        }
        .help-content .title { font-size: 16px; font-weight: 700; color: #1f2937; margin-bottom: 4px; }
        .help-content .describe { font-size: 13px; color: var(--text-muted); line-height: 1.5; }
        .bottom-nav {
            position: fixed; bottom: 0; left: 0; right: 0;
            max-width: 500px; margin: 0 auto; height: 72px;
            background: rgba(255, 255, 255, 0.98); backdrop-filter: blur(20px);
            box-shadow: 0 -8px 32px rgba(0, 0, 0, 0.08);
            border-top: 1px solid rgba(230, 0, 18, 0.1);
            z-index: 1000;
        }
        .nav-wrapper { display: flex; justify-content: space-around; align-items: center; height: 100%; padding: 0 10px; }
        .nav-item {
            flex: 1; display: flex; flex-direction: column; align-items: center; justify-content: center;
            text-decoration: none; color: var(--text-muted); transition: all 0.3s ease; position: relative;
            padding: 8px; border-radius: 12px;
        }
        .nav-item:hover { background: rgba(230, 0, 18, 0.05); }
        .nav-item.active { color: var(--brand-primary); background: rgba(230, 0, 18, 0.08); }
        .nav-item i { font-size: 22px; margin-bottom: 4px; }
        .nav-item span { font-size: 11px; font-weight: 600; letter-spacing: 0.3px; }
        .active-indicator {
            position: absolute; bottom: 0; left: 50%; transform: translateX(-50%);
            width: 40%; height: 3px;
            background: linear-gradient(90deg, var(--brand-primary), var(--brand-dark));
            border-radius: 3px 3px 0 0; opacity: 0; transition: opacity 0.3s ease;
        }
        .nav-item.active .active-indicator { opacity: 1; }
    </style>
</head>
<body>
    <div class="main-container">
        <!-- Header -->
        <header class="page-header">
            <a href="javascript:history.back()" class="back-btn">
                <i class="fas fa-arrow-left"></i>
            </a>
            <h1 class="header-title">Help Center</h1>
            <div class="header-placeholder"></div>
        </header>

        <main class="content-wrapper">
            <!-- Customers Support Card -->
            <a onclick="LiveChatWidget.call('maximize');" class="help-card">
                <div class="help-icon" style="background: linear-gradient(135deg, #3b82f6, #2563eb);">
                    <i class="fas fa-headset"></i>
                </div>
                <div class="help-content">
                    <p class="title">Customers Support</p>
                    <p class="describe">Contact our support team for any assistance.</p>
                </div>
            </a>

            <!-- Telegram Channel Card -->
            <a href='https://t.me/+hnv61dn66PI3MzI1' class="help-card">
                <div class="help-icon" style="background: linear-gradient(135deg, #0ea5e9, #0284c7);">
                    <i class="fab fa-telegram-plane"></i>
                </div>
                <div class="help-content">
                    <p class="title">Telegram Channel</p>
                    <p class="describe">Follow our official channel for the latest news and updates.</p>
                </div>
            </a>
        </main>
    </div>

    <!-- Bottom Navigation -->
    <nav class="bottom-nav">
        <div class="nav-wrapper">
            @php
                $nav_items = [
                    ['path' => 'dashboard', 'icon' => 'fas fa-home', 'label' => 'Home'],
                    ['path' => 'vip', 'icon' => 'fas fa-briefcase', 'label' => 'Plans'],
                    ['path' => 'my-team', 'icon' => 'fas fa-users', 'label' => 'Team'],
                    ['path' => 'my-profile', 'icon' => 'fas fa-user', 'label' => 'Profile'],
                ];
            @endphp
            @foreach($nav_items as $item)
            <a href="{{ url($item['path']) }}" class="nav-item {{ request()->is($item['path']) || request()->is($item['path'].'/*') ? 'active' : '' }}">
                <i class="{{ $item['icon'] }}"></i>
                <span>{{ $item['label'] }}</span>
                @if(request()->is($item['path']) || request()->is($item['path'].'/*'))
                    <div class="active-indicator"></div>
                @endif
            </a>
            @endforeach
        </div>
    </nav>
    
    <!-- কোনো অতিরিক্ত স্ক্রিপ্টের প্রয়োজন নেই -->
</body>
</html>
