<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#e60012">

    <title>My Team — {{ env('APP_NAME') }}</title>
    
    <link rel="icon" type="image/jpg" href="{{ asset('static/images/logo.jpg') }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <style>
        :root {
            --brand-primary: #e60012;
            --brand-dark: #b3000e;
            --text-muted: #6b7280;
            --card-shadow: 0 8px 25px rgba(179, 0, 14, 0.08);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html {
            -webkit-text-size-adjust: 100%;
        }

        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e7e9ef 100%);
            min-height: 100vh;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            -webkit-font-smoothing: antialiased;
            position: relative;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 200px;
            background: linear-gradient(135deg, var(--brand-primary) 0%, var(--brand-dark) 100%);
            z-index: 0;
        }

        .main-container {
            max-width: 500px;
            margin: 0 auto;
            position: relative;
            z-index: 1;
            min-height: 100vh;
            padding-bottom: 100px;
        }

        /* Header */
        .page-header {
            background: transparent;
            padding: 16px 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: relative;
            z-index: 1000;
        }

        .logo-section {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .logo-circle {
            width: 44px;
            height: 44px;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 800;
            font-size: 20px;
            color: var(--brand-primary);
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .logo-text {
            display: flex;
            flex-direction: column;
        }

        .logo-text .main {
            color: #fff;
            font-weight: 700;
            font-size: 16px;
            line-height: 1.2;
        }

        .logo-text .sub {
            color: rgba(255, 255, 255, 0.8);
            font-size: 10px;
            font-weight: 600;
            letter-spacing: 0.5px;
        }

        .notification-btn {
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: none;
            border-radius: 10px;
            color: #fff;
            font-size: 20px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .notification-btn:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        /* Content */
        .content-wrapper {
            padding: 20px;
        }

        /* Stats Grid */
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 14px;
            margin-bottom: 20px;
        }

        .stat-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 18px;
            padding: 22px;
            text-align: center;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.8);
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--brand-primary), var(--brand-dark));
        }

        .stat-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 15px 50px rgba(0, 0, 0, 0.15);
        }

        .stat-value {
            font-size: 28px;
            font-weight: 800;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 6px;
            letter-spacing: -0.5px;
        }

        .stat-label {
            font-size: 13px;
            color: var(--text-muted);
            font-weight: 600;
        }

        /* Referral Card */
        .referral-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 18px;
            padding: 22px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.8);
            margin-bottom: 20px;
            position: relative;
            overflow: hidden;
        }

        .referral-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--brand-primary), var(--brand-dark));
        }

        .referral-header {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 16px;
        }

        .referral-icon {
            width: 36px;
            height: 36px;
            background: linear-gradient(135deg, rgba(230, 0, 18, 0.1), rgba(179, 0, 14, 0.05));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--brand-primary);
            font-size: 16px;
        }

        .referral-header h3 {
            font-size: 16px;
            font-weight: 700;
            color: #1f2937;
        }

        .input-group {
            position: relative;
            display: flex;
            align-items: center;
        }

        .referral-input {
            width: 100%;
            background: #f9fafb;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 14px 90px 14px 14px;
            font-size: 13px;
            color: #1f2937;
            font-weight: 500;
            outline: none;
            transition: all 0.3s ease;
        }

        .referral-input:focus {
            border-color: var(--brand-primary);
            background: #fff;
        }

        .copy-btn {
            position: absolute;
            right: 4px;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            color: #fff;
            border: none;
            border-radius: 10px;
            padding: 10px 20px;
            font-size: 12px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
            letter-spacing: 0.5px;
        }

        .copy-btn:hover {
            transform: scale(1.05);
            box-shadow: 0 4px 15px rgba(230, 0, 18, 0.3);
        }

        /* Section Title */
        .section-title {
            font-size: 16px;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 16px;
            padding: 0 4px;
        }

        /* Level Cards */
        .level-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 18px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.8);
            margin-bottom: 16px;
            overflow: hidden;
            transition: all 0.3s ease;
        }

        .level-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 40px rgba(0, 0, 0, 0.12);
        }

        .level-header {
            padding: 18px 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .level-header.level-1 {
            background: linear-gradient(135deg, rgba(230, 0, 18, 0.08), rgba(230, 0, 18, 0.04));
        }

        .level-header.level-2 {
            background: linear-gradient(135deg, rgba(249, 115, 22, 0.08), rgba(249, 115, 22, 0.04));
        }

        .level-header.level-3 {
            background: linear-gradient(135deg, rgba(14, 165, 233, 0.08), rgba(14, 165, 233, 0.04));
        }

        .level-title {
            display: flex;
            align-items: center;
            gap: 8px;
            font-weight: 700;
            font-size: 15px;
        }

        .level-title.level-1 { color: #dc2626; }
        .level-title.level-2 { color: #ea580c; }
        .level-title.level-3 { color: #0284c7; }

        .level-badge {
            padding: 4px 12px;
            border-radius: 999px;
            font-size: 12px;
            font-weight: 700;
        }

        .level-badge.level-1 {
            background: rgba(220, 38, 38, 0.15);
            color: #dc2626;
        }

        .level-badge.level-2 {
            background: rgba(234, 88, 12, 0.15);
            color: #ea580c;
        }

        .level-badge.level-3 {
            background: rgba(2, 132, 199, 0.15);
            color: #0284c7;
        }

        .level-stats {
            padding: 20px;
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 16px;
            border-top: 1px solid #f3f4f6;
        }

        .level-stat {
            text-align: center;
        }

        .level-stat-value {
            font-weight: 800;
            color: #1f2937;
            font-size: 16px;
            margin-bottom: 4px;
            word-break: break-word;
        }

        .level-stat-label {
            font-size: 12px;
            color: var(--text-muted);
            font-weight: 600;
        }

        /* How It Works */
        .info-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 18px;
            padding: 22px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.8);
            margin-top: 20px;
            position: relative;
            overflow: hidden;
        }

        .info-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--brand-primary), var(--brand-dark));
        }

        .info-header {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 18px;
        }

        .info-icon {
            width: 36px;
            height: 36px;
            background: linear-gradient(135deg, rgba(230, 0, 18, 0.1), rgba(179, 0, 14, 0.05));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--brand-primary);
            font-size: 16px;
        }

        .info-header h3 {
            font-size: 16px;
            font-weight: 700;
            color: #1f2937;
        }

        .info-steps {
            display: flex;
            flex-direction: column;
            gap: 14px;
        }

        .info-step {
            display: flex;
            align-items: flex-start;
            gap: 12px;
        }

        .step-number {
            width: 28px;
            height: 28px;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            color: #fff;
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 13px;
            flex-shrink: 0;
            box-shadow: 0 4px 12px rgba(230, 0, 18, 0.25);
        }

        .step-text {
            font-size: 14px;
            color: #4b5563;
            line-height: 1.6;
            flex: 1;
        }

        .step-text strong {
            color: #1f2937;
            font-weight: 700;
        }

        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            max-width: 500px;
            margin: 0 auto;
            height: 72px;
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            box-shadow: 0 -8px 32px rgba(0, 0, 0, 0.08);
            border-top: 1px solid rgba(230, 0, 18, 0.1);
            z-index: 1000;
        }

        .nav-wrapper {
            display: flex;
            justify-content: space-around;
            align-items: center;
            height: 100%;
            padding: 0 10px;
        }

        .nav-item {
            flex: 1;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-decoration: none;
            color: var(--text-muted);
            transition: all 0.3s ease;
            position: relative;
            padding: 8px;
            border-radius: 12px;
        }

        .nav-item:hover {
            background: rgba(230, 0, 18, 0.05);
        }

        .nav-item.active {
            color: var(--brand-primary);
            background: rgba(230, 0, 18, 0.08);
        }

        .nav-item i {
            font-size: 22px;
            margin-bottom: 4px;
        }

        .nav-item span {
            font-size: 11px;
            font-weight: 600;
            letter-spacing: 0.3px;
        }

        .active-indicator {
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 40%;
            height: 3px;
            background: linear-gradient(90deg, var(--brand-primary), var(--brand-dark));
            border-radius: 3px 3px 0 0;
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .nav-item.active .active-indicator {
            opacity: 1;
        }

        /* Animation */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .page-transition {
            animation: fadeIn 0.5s ease-out;
        }

        /* Responsive */
        @media (max-width: 480px) {
            .content-wrapper {
                padding: 16px;
            }

            .stat-card,
            .referral-card,
            .level-card,
            .info-card {
                padding: 18px;
            }

            .stat-value {
                font-size: 24px;
            }
        }
    </style>
</head>
<body class="page-transition">
    
    <?php
        $team_size = $team_size ?? 0;
        $totalCommission = $totalCommission ?? 0;
        $totalCommission1 = $totalCommission1 ?? 0;
        $totalDeposit1 = $totalDeposit1 ?? 0;
        $first_level_users = $first_level_users ?? collect();
        $totalCommission2 = $totalCommission2 ?? 0;
        $totalDeposit2 = $totalDeposit2 ?? 0;
        $second_level_users = $second_level_users ?? collect();
        $totalCommission3 = $totalCommission3 ?? 0;
        $totalDeposit3 = $totalDeposit3 ?? 0;
        $third_level_users = $third_level_users ?? collect();
    ?>

    <div class="main-container">
        <!-- Header -->
        <header class="page-header">
            <div class="logo-section">
                <div class="logo-circle">
                    {{ substr(env('APP_NAME'), 0, 1) }}
                </div>
                <div class="logo-text">
                    <span class="main">{{ env('APP_NAME') }}</span>
                    <span class="sub">INDUSTRIES LIMITED</span>
                </div>
            </div>
            <button class="notification-btn">
                <i class="far fa-bell"></i>
            </button>
        </header>

        <main class="content-wrapper">
            <!-- Stats Overview -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-value">{{ $team_size }}</div>
                    <div class="stat-label">Total Members</div>
                </div>
                <div class="stat-card">
                    <div class="stat-value">{{ price($totalCommission, 2) }}</div>
                    <div class="stat-label">Total Commission</div>
                </div>
            </div>

            <!-- Referral Link -->
            <div class="referral-card">
                <div class="referral-header">
                    <div class="referral-icon">
                        <i class="fas fa-link"></i>
                    </div>
                    <h3>Your Referral Link</h3>
                </div>
                <div class="input-group">
                    <input type="text" class="referral-input" id="inviteLink" value="{{ url('register').'?inviteCode='.auth()->user()->ref_id }}" readonly>
                    <button class="copy-btn" onclick="copyToClipboard()">COPY</button>
                </div>
            </div>

            <!-- Team Levels Title -->
            <h3 class="section-title">Team Levels</h3>

            <!-- Level 1 Card -->
            <div class="level-card">
                <div class="level-header level-1">
                    <div class="level-title level-1">
                        <i class="fas fa-trophy"></i>
                        First Level
                    </div>
                    <span class="level-badge level-1">27%</span>
                </div>
                <div class="level-stats">
                    <div class="level-stat">
                        <div class="level-stat-value">{{ price($totalCommission1, 2) }}</div>
                        <div class="level-stat-label">Commission</div>
                    </div>
                    <div class="level-stat">
                        <div class="level-stat-value">{{ price($totalDeposit1, 2) }}</div>
                        <div class="level-stat-label">Recharges</div>
                    </div>
                    <div class="level-stat">
                        <div class="level-stat-value">{{ $first_level_users->count() }}</div>
                        <div class="level-stat-label">Members</div>
                    </div>
                </div>
            </div>

            <!-- Level 2 Card -->
            <div class="level-card">
                <div class="level-header level-2">
                    <div class="level-title level-2">
                        <i class="fas fa-award"></i>
                        Second Level
                    </div>
                    <span class="level-badge level-2">2%</span>
                </div>
                <div class="level-stats">
                    <div class="level-stat">
                        <div class="level-stat-value">{{ price($totalCommission2, 2) }}</div>
                        <div class="level-stat-label">Commission</div>
                    </div>
                    <div class="level-stat">
                        <div class="level-stat-value">{{ price($totalDeposit2, 2) }}</div>
                        <div class="level-stat-label">Recharges</div>
                    </div>
                    <div class="level-stat">
                        <div class="level-stat-value">{{ $second_level_users->count() }}</div>
                        <div class="level-stat-label">Members</div>
                    </div>
                </div>
            </div>

            <!-- Level 3 Card -->
            <div class="level-card">
                <div class="level-header level-3">
                    <div class="level-title level-3">
                        <i class="fas fa-star"></i>
                        Third Level
                    </div>
                    <span class="level-badge level-3">1%</span>
                </div>
                <div class="level-stats">
                    <div class="level-stat">
                        <div class="level-stat-value">{{ price($totalCommission3, 2) }}</div>
                        <div class="level-stat-label">Commission</div>
                    </div>
                    <div class="level-stat">
                        <div class="level-stat-value">{{ price($totalDeposit3, 2) }}</div>
                        <div class="level-stat-label">Recharges</div>
                    </div>
                    <div class="level-stat">
                        <div class="level-stat-value">{{ $third_level_users->count() }}</div>
                        <div class="level-stat-label">Members</div>
                    </div>
                </div>
            </div>
            
            <!-- How It Works Card -->
            <div class="info-card">
                <div class="info-header">
                    <div class="info-icon">
                        <i class="fas fa-circle-info"></i>
                    </div>
                    <h3>How It Works</h3>
                </div>
                <div class="info-steps">
                    <div class="info-step">
                        <div class="step-number">1</div>
                        <div class="step-text"><strong>Copy Link:</strong> Click COPY to get your unique referral link.</div>
                    </div>
                    <div class="info-step">
                        <div class="step-number">2</div>
                        <div class="step-text"><strong>Share:</strong> Share this link with your friends on social media.</div>
                    </div>
                    <div class="info-step">
                        <div class="step-number">3</div>
                        <div class="step-text"><strong>Earn:</strong> You'll earn commissions when friends invest.</div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Bottom Navigation -->
    <nav class="bottom-nav">
        <div class="nav-wrapper">
            @php
                $nav_items = [
                    ['path' => 'dashboard', 'icon' => 'fas fa-home', 'label' => 'Home'],
                    ['path' => 'vip', 'icon' => 'fas fa-briefcase', 'label' => 'Plans'],
                    ['path' => 'my-team', 'icon' => 'fas fa-users', 'label' => 'Team'],
                    ['path' => 'my-profile', 'icon' => 'fas fa-user', 'label' => 'Profile'],
                ];
            @endphp
            @foreach($nav_items as $item)
            <a href="{{ url($item['path']) }}" class="nav-item {{ request()->is($item['path']) || request()->is($item['path'].'/*') ? 'active' : '' }}">
                <i class="{{ $item['icon'] }}"></i>
                <span>{{ $item['label'] }}</span>
                @if(request()->is($item['path']) || request()->is($item['path'].'/*'))
                    <div class="active-indicator"></div>
                @endif
            </a>
            @endforeach
        </div>
    </nav>
    
    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            toastr.options = { 
                "closeButton": true, 
                "progressBar": true, 
                "positionClass": "toast-top-right",
                "timeOut": "3000",
            };

            @if(session('success'))
                toastr.success("{{ session('success') }}");
            @endif
            @if(session('error'))
                toastr.error("{{ session('error') }}");
            @endif
        });

        function copyToClipboard() {
            const textToCopy = document.getElementById('inviteLink').value;

            // Use modern clipboard API if available (requires HTTPS)
            if (navigator.clipboard && window.isSecureContext) {
                navigator.clipboard.writeText(textToCopy).then(() => {
                    toastr.success('Referral link copied successfully!');
                }).catch(err => {
                    toastr.error('Could not copy link.');
                });
            } else {
                // Fallback for older browsers or insecure contexts
                const textArea = document.createElement("textarea");
                textArea.value = textToCopy;
                
                // Make the textarea invisible
                textArea.style.position = "fixed";
                textArea.style.top = "-9999px";
                textArea.style.left = "-9999px";

                document.body.appendChild(textArea);
                textArea.focus();
                textArea.select();

                try {
                    document.execCommand('copy');
                    toastr.success('Referral link copied successfully!');
                } catch (err) {
                    toastr.error('Failed to copy link.');
                }

                document.body.removeChild(textArea);
            }
        }
    </script>
</body>
</html>