<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no">
    <title>Plan Store - Nova</title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Google Fonts & Font Awesome -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <style>
        /* Nova's original styling for 100% same design */
        body { font-family: 'Inter', sans-serif; overflow-x: hidden; }
        .active-indicator {
            position: absolute; bottom: 0; left: 50%; transform: translateX(-50%);
            width: 60%; height: 3px; background: linear-gradient(90deg, #dc2626, #ef4444);
            border-radius: 3px 3px 0 0; box-shadow: 0 0 10px rgba(220, 38, 38, 0.5);
        }
        .nav-item.active { transform: translateY(-2px); }
        nav.bottom-nav { position: fixed !important; bottom: 0; left: 0; right: 0; z-index: 50; }
        .main-content { padding-bottom: 100px; }

        /* Tab content visibility logic */
        .tab-content { display: none; }
        .tab-content.active { display: grid; } /* Using grid to ensure two columns */
    </style>
</head>
<body class="bg-white min-h-screen">

    <?php
        // Laravel Blade syntax for dynamic data.
        use App\Models\Package;
        
        $dailyPlans = Package::where('status', '!=', 'inactive')->where('tab', 'vip')->get();
        $welfarePlans = Package::where('status', '!=', 'inactive')->where('tab', 'fixed')->get();
    ?>

    <div class="main-content relative z-10">
        <div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-50 pb-4">
            <div class="w-full px-2 md:px-4 py-2 md:py-4">
                
                <!-- Modern Tab Selection -->
                <div class="mb-4 md:mb-6">
                    <div class="bg-white/60 backdrop-blur-md rounded-3xl p-1.5 shadow-lg border border-white/50 inline-flex">
                        <button id="daily-tab" class="tab flex-1 px-4 md:px-8 py-2 md:py-3 bg-gradient-to-r from-red-600 to-red-700 text-white rounded-2xl font-semibold text-xs md:text-sm shadow-lg shadow-red-500/30 transition-all" data-tab="daily-plans">
                            Daily Plans
                        </button>
                        <button id="welfare-tab" class="tab flex-1 px-4 md:px-8 py-2 md:py-3 text-gray-600 rounded-2xl font-semibold text-xs md:text-sm transition-all" data-tab="welfare-plans">
                            Welfare Plans
                        </button>
                    </div>
                </div>

                <!-- Daily Investment Plans Grid -->
                <div id="daily-plans" class="tab-content active grid-cols-2 gap-1 md:gap-4">
                    @forelse($dailyPlans as $plan)
                    <div class="group bg-white rounded-2xl md:rounded-3xl shadow-lg hover:shadow-2xl transition-all duration-500 overflow-hidden border border-gray-100 hover:border-red-200 transform hover:scale-105">
                        <div class="relative p-3 md:p-4">
                            <div class="flex items-center justify-between mb-2">
                                <span class="px-2 md:px-4 py-0.5 md:py-1 bg-gradient-to-r from-blue-500 to-blue-600 text-white text-xs font-bold rounded-full shadow-lg">{{ $plan->name }}</span>
                                <span class="px-2 md:px-4 py-0.5 md:py-1 bg-gradient-to-r from-green-500 to-emerald-500 text-white text-xs font-bold rounded-full shadow-lg">{{ $plan->validity }} Days</span>
                            </div>
                            <div class="relative mb-2 flex justify-center">
                                <div class="w-14 h-14 md:w-20 md:h-20 rounded-xl md:rounded-2xl overflow-hidden shadow-xl ring-2 md:ring-3 ring-blue-100 transform group-hover:scale-110 transition-transform duration-500">
                                    <img src="{{ asset($plan->photo) }}" alt="{{ $plan->name }}" class="w-full h-full object-cover">
                                </div>
                            </div>
                            <div class="bg-gradient-to-br from-gray-50 to-blue-50 rounded-xl p-2 mb-2">
                                <div class="grid grid-cols-2 gap-2 text-center">
                                    <div>
                                        <p class="text-sm md:text-2xl font-black text-red-600">৳{{ number_format($plan->daily_limit, 2) }}</p>
                                        <p class="text-xs text-gray-600 font-semibold mt-0.5">Daily Income</p>
                                    </div>
                                    <div>
                                        <p class="text-sm md:text-2xl font-black text-green-600">৳{{ number_format($plan->daily_limit * $plan->validity, 2) }}</p>
                                        <p class="text-xs text-gray-600 font-semibold mt-0.5">Total Income</p>
                                    </div>
                                </div>
                            </div>
                            <div class="text-center mb-2">
                                <div class="inline-flex items-baseline">
                                    <span class="text-gray-500 text-xs font-semibold mr-2">Price:</span>
                                    <span class="text-base md:text-xl font-black text-gray-900">৳{{ number_format($plan->price, 2) }}</span>
                                </div>
                            </div>
                            @if($plan->status == 'coming')
                                <button disabled class="w-full bg-gradient-to-r from-gray-300 to-gray-400 text-white py-2 md:py-3 rounded-xl font-bold text-xs md:text-sm shadow-lg opacity-70 cursor-not-allowed">Coming Soon</button>
                            @else
                                <a href="/purchase/confirmation/{{ $plan->id }}" class="block text-center w-full bg-gradient-to-r from-red-500 to-orange-500 hover:from-red-600 hover:to-orange-600 text-white py-2 md:py-3 rounded-xl font-bold text-xs md:text-sm shadow-lg hover:shadow-xl transition-all">Invest Now</a>
                            @endif
                        </div>
                    </div>
                    @empty
                        <p class="col-span-2 text-center text-gray-500 py-10">No daily plans available right now.</p>
                    @endforelse
                </div>

                <!-- Welfare Plans Grid -->
                <div id="welfare-plans" class="tab-content grid-cols-2 gap-1 md:gap-4">
                    @forelse($welfarePlans as $plan)
                    <div class="group bg-white rounded-2xl md:rounded-3xl shadow-lg hover:shadow-2xl transition-all duration-500 overflow-hidden border border-gray-100 hover:border-blue-200 transform hover:scale-105">
                        <div class="relative p-3 md:p-4">
                            <div class="flex items-center justify-between mb-2">
                                <span class="px-2 md:px-4 py-0.5 md:py-1 bg-gradient-to-r from-blue-500 to-blue-600 text-white text-xs font-bold rounded-full shadow-lg">{{ $plan->name }}</span>
                                <span class="px-2 md:px-4 py-0.5 md:py-1 bg-gradient-to-r from-green-500 to-emerald-500 text-white text-xs font-bold rounded-full shadow-lg">{{ $plan->validity }} Days</span>
                            </div>
                            <div class="relative mb-2 flex justify-center">
                                <div class="w-14 h-14 md:w-20 md:h-20 rounded-xl md:rounded-2xl overflow-hidden shadow-xl ring-2 md:ring-3 ring-blue-100 transform group-hover:scale-110 transition-transform duration-500">
                                    <img src="{{ asset($plan->photo) }}" alt="{{ $plan->name }}" class="w-full h-full object-cover">
                                </div>
                            </div>
                            <div class="bg-gradient-to-br from-gray-50 to-blue-50 rounded-xl p-2 mb-2">
                                <div class="grid grid-cols-2 gap-2 text-center">
                                    <div>
                                        <p class="text-sm md:text-2xl font-black text-red-600">৳{{ number_format($plan->daily_limit, 2) }}</p>
                                        <p class="text-xs text-gray-600 font-semibold mt-0.5">Daily Income</p>
                                    </div>
                                    <div>
                                        <p class="text-sm md:text-2xl font-black text-green-600">৳{{ number_format($plan->daily_limit * $plan->validity, 2) }}</p>
                                        <p class="text-xs text-gray-600 font-semibold mt-0.5">Total Income</p>
                                    </div>
                                </div>
                            </div>
                            <div class="text-center mb-2">
                                <div class="inline-flex items-baseline">
                                    <span class="text-gray-500 text-xs font-semibold mr-2">Price:</span>
                                    <span class="text-base md:text-xl font-black text-gray-900">৳{{ number_format($plan->price, 2) }}</span>
                                </div>
                            </div>
                            @if($plan->status == 'coming')
                                <button disabled class="w-full bg-gradient-to-r from-gray-300 to-gray-400 text-white py-2 md:py-3 rounded-xl font-bold text-xs md:text-sm shadow-lg opacity-70 cursor-not-allowed">Coming Soon</button>
                            @else
                                <a href="/purchase/confirmation/{{ $plan->id }}" class="block text-center w-full bg-gradient-to-r from-blue-500 to-indigo-500 hover:from-blue-600 hover:to-indigo-600 text-white py-2 md:py-3 rounded-xl font-bold text-xs md:text-sm shadow-lg hover:shadow-xl transition-all">Invest Now</a>
                            @endif
                        </div>
                    </div>
                    @empty
                        <p class="col-span-2 text-center text-gray-500 py-10">No welfare plans available right now.</p>
                    @endforelse
                </div>
            </div>
        </div>
    </div>


    <!-- Bottom Navigation -->
    <nav class="bottom-nav bg-gradient-to-t from-white via-white to-white/95 backdrop-blur-lg shadow-[0_-8px_32px_rgba(0,0,0,0.12)] border-t border-red-100">
        <div class="flex justify-around items-center w-full h-full">
            @php
                $nav_items = [
                    ['path' => 'dashboard', 'icon' => 'fas fa-home', 'label' => 'Home'],
                    ['path' => 'vip', 'icon' => 'fas fa-briefcase', 'label' => 'Plans'],
                    ['path' => 'my-team', 'icon' => 'fas fa-users', 'label' => 'Team'],
                    ['path' => 'my-profile', 'icon' => 'fas fa-user', 'label' => 'Profile'],
                ];
            @endphp
            @foreach($nav_items as $item)
            <a href="{{ url($item['path']) }}" class="nav-item flex-1 flex flex-col items-center justify-center relative rounded-2xl text-gray-500 hover:text-red-500 transition-all duration-300 {{ request()->is($item['path']) ? 'text-red-600 bg-red-50 active' : '' }}">
                <div class="relative">
                    <i class="{{ $item['icon'] }} text-xl mb-1"></i>
                    @if(request()->is($item['path']))
                        <div class="active-indicator"></div>
                    @endif
                </div>
                <span class="font-poppins text-[10px] font-semibold tracking-wide">{{ $item['label'] }}</span>
            </a>
            @endforeach
        </div>
    </nav>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Tab switching logic
            const tabs = document.querySelectorAll('.tab');
            const tabContents = document.querySelectorAll('.tab-content');
            const dailyTab = document.getElementById('daily-tab');
            const welfareTab = document.getElementById('welfare-tab');

            tabs.forEach(tab => {
                tab.addEventListener('click', function () {
                    const targetId = this.getAttribute('data-tab');
                    
                    tabContents.forEach(c => c.classList.remove('active'));
                    document.getElementById(targetId).classList.add('active');

                    if (targetId === 'daily-plans') {
                        dailyTab.className = 'tab flex-1 px-4 md:px-8 py-2 md:py-3 bg-gradient-to-r from-red-600 to-red-700 text-white rounded-2xl font-semibold text-xs md:text-sm shadow-lg shadow-red-500/30 transition-all';
                        welfareTab.className = 'tab flex-1 px-4 md:px-8 py-2 md:py-3 text-gray-600 rounded-2xl font-semibold text-xs md:text-sm transition-all';
                    } else {
                        dailyTab.className = 'tab flex-1 px-4 md:px-8 py-2 md:py-3 text-gray-600 rounded-2xl font-semibold text-xs md:text-sm transition-all';
                        welfareTab.className = 'tab flex-1 px-4 md:px-8 py-2 md:py-3 bg-gradient-to-r from-blue-600 to-blue-700 text-white rounded-2xl font-semibold text-xs md:text-sm shadow-lg shadow-blue-500/30 transition-all';
                    }
                });
            });

            // The following JavaScript is for making other links active if you navigate away.
            // On this page, "Plans" will remain active as set in the HTML.
            const navItems = document.querySelectorAll('.bottom-nav .nav-item:not(.active)'); // Select only non-active items
            const currentPath = window.location.pathname;

            navItems.forEach(item => {
                const itemPath = new URL(item.href).pathname;
                if (currentPath === itemPath) {
                    // Deactivate any currently active item (except the one hardcoded)
                    document.querySelector('.bottom-nav .nav-item.active')?.classList.remove('active', 'text-red-600', 'bg-red-50');
                    document.querySelector('.bottom-nav .active-indicator')?.remove();
                    
                    // Activate the new one
                    item.classList.add('active', 'text-red-600', 'bg-red-50');
                    item.classList.remove('text-gray-500');
                    
                    const indicator = document.createElement('div');
                    indicator.className = 'active-indicator';
                    item.appendChild(indicator);
                }
            });
        });
    </script>
</body>
</html>