<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="mobile-web-app-capable" content="yes">
    <title><?php echo e(env('APP_NAME')); ?> | Login</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" type="image/png" href="<?php echo e(asset('static/images/logo.jpg')); ?>">
    
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Sora:wght@300;400;500;600;700;800&display=swap');
        
        * {
            font-family: 'Sora', sans-serif;
            -webkit-tap-highlight-color: transparent;
        }
        
        html, body {
            height: 100%;
            height: 100vh;
            height: 100dvh;
            margin: 0;
            padding: 0;
            overflow: hidden;
        }
        
        body {
            background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%);
            position: fixed;
            width: 100%;
            color: #1e293b;
        }
        
        .main-wrapper {
            height: 100vh;
            height: 100dvh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            overflow: hidden;
        }
        
        /* Animated Background Elements */
        .bg-elements {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%; 
            height: 100%;
            z-index: 0;
            pointer-events: none;
            overflow: hidden;
        }
        
        .bg-element {
            position: absolute;
            border-radius: 50%;
            opacity: 0.05;
            animation: float 20s ease-in-out infinite;
        }
        
        .bg-element-1 {
            width: 300px;
            height: 300px;
            background: linear-gradient(135deg, #3b82f6, #8b5cf6);
            top: -100px;
            left: -100px;
            animation-delay: 0s;
        }
        
        .bg-element-2 {
            width: 250px;
            height: 250px;
            background: linear-gradient(135deg, #ec4899, #f59e0b);
            bottom: -50px;
            right: -50px;
            animation-delay: 5s;
        }
        
        .bg-element-3 {
            width: 200px;
            height: 200px;
            background: linear-gradient(135deg, #10b981, #06b6d4);
            top: 50%;
            right: 10%;
            animation-delay: 10s;
        }
        
        @keyframes float {
            0%, 100% { transform: translate(0, 0) scale(1); }
            50% { transform: translate(30px, 30px) scale(1.1); }
        }
        
        .login-container {
            width: 100%;
            max-width: 500px;
            background: white;
            border-radius: 24px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25), 0 0 0 1px rgba(0, 0, 0, 0.05);
            padding: 50px 40px;
            animation: slideUp 0.7s cubic-bezier(0.34, 1.56, 0.64, 1);
            position: relative;
            z-index: 10;
        }
        
        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(40px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .logo-section {
            text-align: center;
            margin-bottom: 40px;
        }
        
        .logo-icon {
            width: 70px;
            height: 70px;
            margin: 0 auto 20px;
            background: linear-gradient(135deg, #3b82f6 0%, #8b5cf6 100%);
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            box-shadow: 0 10px 25px rgba(59, 130, 246, 0.3);
            animation: bounce 2.5s ease-in-out infinite;
        }

        .logo-icon img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        @keyframes bounce {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-12px); }
        }
        
        .header-title {
            font-size: 32px;
            font-weight: 800;
            color: #0f172a;
            margin: 0 0 8px 0;
            letter-spacing: -0.5px;
        }
        
        .header-subtitle {
            font-size: 15px;
            color: #64748b;
            margin: 0;
            font-weight: 400;
            line-height: 1.5;
        }
        
        .form-group {
            margin-bottom: 24px;
        }
        
        .form-label {
            display: block;
            font-size: 13px;
            font-weight: 700;
            color: #1e293b;
            margin-bottom: 10px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .input-wrapper {
            position: relative;
            display: flex;
            align-items: center;
        }
        
        .input-icon {
            position: absolute;
            left: 16px;
            top: 50%;
            transform: translateY(-50%);
            color: #94a3b8;
            font-size: 18px;
            z-index: 5;
            transition: all 0.3s ease;
            font-weight: 600;
        }
        
        .input-field {
            width: 100%;
            padding: 16px 16px 16px 52px;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 500;
            color: #0f172a;
            background: #f8fafc;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            outline: none;
            letter-spacing: 0.3px;
        }
        
        .input-field::placeholder {
            color: #cbd5e0;
            font-weight: 500;
        }
        
        .input-field:focus {
            border-color: #3b82f6;
            background: white;
            box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.1), inset 0 0 0 1px rgba(59, 130, 246, 0.05);
            transform: translateY(-2px);
        }
        
        .input-field:focus + .input-icon {
            color: #3b82f6;
            transform: translateY(-50%) scale(1.15);
        }
        
        .input-field-phone {
            padding-left: 90px;
        }
        
        .phone-prefix {
            position: absolute;
            left: 52px;
            top: 50%;
            transform: translateY(-50%);
            color: #1e293b;
            font-weight: 700;
            font-size: 15px;
            z-index: 5;
            letter-spacing: 0.5px;
        }
        
        .password-toggle {
            position: absolute;
            right: 14px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #94a3b8;
            cursor: pointer;
            font-size: 18px;
            padding: 8px 12px;
            transition: all 0.3s ease;
            z-index: 5;
            font-weight: 600;
        }
        
        .password-toggle:hover {
            color: #3b82f6;
            transform: translateY(-50%) scale(1.15);
        }
        
        .password-toggle:active {
            transform: translateY(-50%) scale(0.95);
        }
        
        .error-message {
            font-size: 13px;
            color: #dc2626;
            margin-top: 8px;
            margin-left: 4px;
            display: flex;
            align-items: center;
            gap: 6px;
            animation: slideDown 0.3s ease;
            font-weight: 600;
        }
        
        @keyframes slideDown {
            from {
                opacity: 0;
                transform: translateY(-8px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .error-message::before {
            content: '✕';
            font-size: 16px;
            font-weight: 700;
        }
        
        .submit-btn {
            width: 100%;
            padding: 16px 24px;
            margin-top: 32px;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 700;
            color: white;
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            cursor: pointer;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            box-shadow: 0 10px 25px rgba(59, 130, 246, 0.3);
            text-transform: uppercase;
            letter-spacing: 1.2px;
        }
        
        .submit-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.4), transparent);
            transition: left 0.6s ease;
        }
        
        .submit-btn:hover:not(:disabled) {
            transform: translateY(-4px);
            box-shadow: 0 15px 40px rgba(59, 130, 246, 0.4);
        }
        
        .submit-btn:hover:not(:disabled)::before {
            left: 100%;
        }
        
        .submit-btn:active:not(:disabled) {
            transform: translateY(-1px);
        }
        
        .submit-btn:disabled {
            opacity: 0.7;
            cursor: not-allowed;
        }

        .divider {
            display: flex;
            align-items: center;
            margin: 32px 0;
        }
        
        .divider-line {
            flex: 1;
            height: 1px;
            background: #e2e8f0;
        }
        
        .divider-text {
            padding: 0 16px;
            color: #94a3b8;
            font-size: 14px;
            font-weight: 500;
        }
        
        .register-section {
            text-align: center;
            background: #f8fafc;
            margin: 0 -40px -50px -40px;
            padding: 24px;
            border-radius: 0 0 24px 24px;
            border-top: 1px solid #e2e8f0;
        }
        
        .register-text {
            color: #64748b;
            font-size: 15px;
        }
        
        .register-link {
            color: #3b82f6;
            font-weight: 700;
            text-decoration: none;
            margin-left: 4px;
            transition: all 0.3s ease;
        }
        
        .register-link:hover {
            color: #2563eb;
            text-decoration: underline;
        }
        
        /* Mobile Optimization */
        @media (max-width: 480px) {
            .login-container {
                padding: 40px 24px;
                border-radius: 20px;
            }
            
            .logo-icon {
                width: 55px;
                height: 55px;
                font-size: 28px;
                margin-bottom: 16px;
            }
            
            .header-title {
                font-size: 24px;
                margin-bottom: 6px;
            }
            
            .header-subtitle {
                font-size: 13px;
            }
            
            .form-group {
                margin-bottom: 20px;
            }
            
            .form-label {
                font-size: 11px;
                margin-bottom: 8px;
            }
            
            .input-field {
                padding: 13px 12px 13px 44px;
                font-size: 14px;
                border-radius: 10px;
            }
            
            .input-icon {
                font-size: 15px;
                left: 12px;
            }
            
            .phone-prefix {
                left: 44px;
                font-size: 13px;
            }
            
            .password-toggle {
                font-size: 16px;
                right: 12px;
                padding: 6px 10px;
            }
            
            .submit-btn {
                padding: 13px 18px;
                font-size: 14px;
                margin-top: 24px;
                letter-spacing: 0.8px;
            }
            
            .error-message {
                font-size: 12px;
                margin-top: 6px;
            }
            
            .divider {
                margin: 28px 0;
            }
            
            .register-section {
                padding: 16px;
            }
            
            .register-text {
                font-size: 13px;
            }
        }
        
        /* Dark mode support */
        @media (prefers-color-scheme: dark) {
            body {
                background: linear-gradient(135deg, #0f172a 0%, #1e293b 50%, #0f172a 100%);
            }
        }
    </style>
</head>
<body>
    
    <!-- Animated Background Elements -->
    <div class="bg-elements">
        <div class="bg-element bg-element-1"></div>
        <div class="bg-element bg-element-2"></div>
        <div class="bg-element bg-element-3"></div>
    </div>
    
    <div class="main-wrapper">
        <div class="login-container">
            
            <!-- Logo Section -->
            <div class="logo-section">
                <div class="logo-icon">
                    <a href="<?php echo e(url('/login')); ?>" style="display: block; width: 100%; height: 100%;">
                        <img src="https://i.postimg.cc/qMX2HKS6/IMG-20260121-WA0002.jpg" alt="Logo">
                    </a>
                </div>
                <h1 class="header-title">Welcome Back</h1>
                <p class="header-subtitle">Sign in to your account to continue</p>
            </div>
            
            <!-- Fully Functional Login Form -->
            <form id="loginForm" action="<?php echo e(url('login')); ?>" method="POST" autocomplete="off">
                <?php echo csrf_field(); ?>
                
                <!-- Phone Number -->
                <div class="form-group">
                    <label class="form-label">Phone Number</label>
                    <div class="input-wrapper">
                        <i class="fas fa-phone input-icon"></i>
                    
                        <input 
                            type="tel" 
                            inputmode="numeric" 
                            class="input-field input-field-phone" 
                            name="phone" 
                        
                            required 
                            autocomplete="tel"
                        >
                    </div>
                    <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <!-- Password -->
                <div class="form-group">
                    <label class="form-label">Password</label>
                    <div class="input-wrapper">
                        <i class="fas fa-lock input-icon"></i>
                        <input 
                            type="password" 
                            class="input-field" 
                            id="password" 
                            name="password" 
                            placeholder="Enter your password" 
                            required 
                            autocomplete="current-password"
                        >
                        <button 
                            type="button" 
                            class="password-toggle" 
                            onclick="togglePassword()"
                            aria-label="Toggle password visibility"
                        >
                            <i class="fas fa-eye-slash" id="toggleIcon"></i>
                        </button>
                    </div>
                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="error-message"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
                
                <!-- Login Button -->
                <button type="submit" class="submit-btn">
                    <span class="flex items-center justify-center">
                        <i class="fas fa-sign-in-alt mr-3"></i>
                        Sign In
                    </span>
                </button>
            </form>
            
            <!-- Divider -->
            <div class="divider">
                <div class="divider-line"></div>
                <span class="divider-text">New User?</span>
                <div class="divider-line"></div>
            </div>
            
            <!-- Register Section -->
            <div class="register-section">
                <p class="register-text">
                    Don't have an account?
                    <a href="<?php echo e(url('register')); ?>" class="register-link">Create one now</a>
                </p>
            </div>
            
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script>
        // 1. Toastr Notification Setup
        toastr.options = {
            "closeButton": true,
            "progressBar": true,
            "positionClass": "toast-top-right",
            "timeOut": 5000,
            "extendedTimeOut": 1000,
            "showEasing": "swing",
            "hideEasing": "linear",
            "showMethod": "fadeIn",
            "hideMethod": "fadeOut"
        };
        
        // Display validation errors from Laravel
        <?php if(session('error')): ?>
            toastr.error("<?php echo e(session('error')); ?>");
        <?php endif; ?>
        <?php if($errors->any()): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                toastr.error("<?php echo e($error); ?>");
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>

        // 2. Password Toggle Function
        function togglePassword() {
            const passwordField = document.getElementById('password');
            const toggleIcon = document.getElementById('toggleIcon');
            
            if (passwordField.type === 'password') {
                passwordField.type = 'text';
                toggleIcon.classList.remove('fa-eye-slash');
                toggleIcon.classList.add('fa-eye');
            } else {
                passwordField.type = 'password';
                toggleIcon.classList.remove('fa-eye');
                toggleIcon.classList.add('fa-eye-slash');
            }
        }

        // 3. Form Submission with Button Loading State
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const submitBtn = this.querySelector('button[type="submit"]');
            
            if (submitBtn.disabled) {
                e.preventDefault();
                return;
            }
            
            // Store original content
            const originalContent = submitBtn.innerHTML;
            
            // Show loading state
            submitBtn.innerHTML = '<span class="flex items-center justify-center"><span class="spinner mr-3"></span>Signing In...</span>';
            submitBtn.disabled = true;
            
            // Optional: Restore button after timeout (fallback)
            setTimeout(() => {
                if (submitBtn.disabled) {
                    submitBtn.innerHTML = originalContent;
                    submitBtn.disabled = false;
                }
            }, 10000);
        });

        // 4. Prevent double-tap zoom on iOS
        let lastTouchEnd = 0;
        document.addEventListener('touchend', function(event) {
            const now = Date.now();
            if (now - lastTouchEnd <= 300) {
                event.preventDefault();
            }
            lastTouchEnd = now;
        }, false);
        
        // 5. Phone Input Validation - Only Numbers
        const phoneInput = document.querySelector('input[name="phone"]');
        phoneInput.addEventListener('input', function() {
            this.value = this.value.replace(/[^0-9]/g, '');
            
            // Add success state if valid
            if (this.value.length === 10) {
                this.classList.add('success');
            } else {
                this.classList.remove('success');
            }
        });
        
        // 6. Password Field Validation
        const passwordInput = document.querySelector('input[name="password"]');
        passwordInput.addEventListener('input', function() {
            if (this.value.length >= 6) {
                this.classList.add('success');
            } else {
                this.classList.remove('success');
            }
        });
        
        // 7. Smooth Focus Management
        document.querySelectorAll('.input-field').forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.parentElement.classList.add('focused');
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.parentElement.classList.remove('focused');
            });
        });
        
        // 8. Prevent form submission on Enter key in input fields (optional)
        document.querySelectorAll('.input-field').forEach(input => {
            input.addEventListener('keypress', function(e) {
                if (e.key === 'Enter' && this.name !== 'password') {
                    // Move to next field or submit
                    if (this.name === 'phone') {
                        passwordInput.focus();
                    }
                }
            });
        });
    </script>
</body>
</html><?php /**PATH /home/khelawin124/trustwallet.dpdns.org/resources/views/app/auth/login.blade.php ENDPATH**/ ?>