<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Deposit History</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        :root {
            --brand-primary: #e60012;
            --brand-dark: #b3000e;
            --text-muted: #6b7280;
            --card-shadow: 0 8px 25px rgba(179, 0, 14, 0.08);
            --success-color: #10b981;
            --pending-color: #f59e0b;
            --failed-color: #ef4444;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e7e9ef 100%);
            min-height: 100vh;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
            -webkit-font-smoothing: antialiased;
            position: relative;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 280px;
            background: linear-gradient(135deg, var(--brand-primary) 0%, var(--brand-dark) 100%);
            z-index: 0;
        }

        /* Header */
        .page-header {
            background: transparent;
            color: #fff;
            padding: 0 20px;
            height: 60px;
            font-size: 20px;
            font-weight: 700;
            position: relative;
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .back-arrow {
            color: #fff;
            font-size: 22px;
            text-decoration: none;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }

        .back-arrow:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateX(-3px);
        }
        
        .header-placeholder {
            width: 32px;
        }

        .header-title {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .header-icon {
            width: 36px;
            height: 36px;
            background: rgba(255, 255, 255, 0.15);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            backdrop-filter: blur(10px);
        }

        /* Main Content */
        .content-area {
            padding: 20px;
            position: relative;
            z-index: 1;
            max-width: 500px;
            margin: 0 auto;
        }

        /* Summary Card */
        .summary-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            padding: 24px;
            margin-bottom: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.8);
            position: relative;
            overflow: hidden;
        }

        .summary-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--success-color), #059669);
        }

        .summary-card::after {
            content: '';
            position: absolute;
            top: -50%;
            right: -20%;
            width: 200px;
            height: 200px;
            background: radial-gradient(circle, rgba(16, 185, 129, 0.08) 0%, transparent 70%);
            border-radius: 50%;
        }

        .summary-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: relative;
            z-index: 1;
        }

        .summary-left {
            display: flex;
            align-items: center;
            gap: 14px;
        }

        .summary-icon {
            width: 52px;
            height: 52px;
            background: linear-gradient(135deg, var(--success-color), #059669);
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 24px;
            box-shadow: 0 6px 20px rgba(16, 185, 129, 0.3);
        }

        .summary-info h3 {
            font-size: 14px;
            color: var(--text-muted);
            font-weight: 600;
            margin-bottom: 6px;
        }

        .summary-info p {
            font-size: 28px;
            font-weight: 800;
            color: var(--success-color);
            letter-spacing: -0.5px;
        }

        /* Record Card */
        .record-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            margin-bottom: 14px;
            border-radius: 16px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            gap: 14px;
            padding: 16px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .record-card::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            bottom: 0;
            width: 4px;
            background: linear-gradient(180deg, var(--success-color), #059669);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .record-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.12);
        }

        .record-card:hover::before {
            opacity: 1;
        }

        .record-card:active {
            transform: translateY(0);
        }
        
        .icon-container {
            width: 52px;
            height: 52px;
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            flex-shrink: 0;
            font-size: 22px;
            background: linear-gradient(135deg, var(--success-color), #059669);
            box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
            position: relative;
            overflow: hidden;
        }

        .icon-container::after {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.2) 0%, transparent 70%);
            border-radius: 50%;
        }

        .details-container {
            flex-grow: 1;
            min-width: 0;
        }

        .details-container b {
            font-weight: 700;
            color: #1f2937;
            display: block;
            font-size: 16px;
            margin-bottom: 6px;
            letter-spacing: 0.2px;
        }

        .details-container small {
            font-size: 13px;
            color: var(--text-muted);
            display: flex;
            align-items: center;
            gap: 6px;
            font-weight: 500;
        }

        .details-container small i {
            font-size: 12px;
            color: var(--success-color);
        }

        .amount-container {
            text-align: right;
            flex-shrink: 0;
        }

        .amount-positive {
            color: var(--success-color);
            font-weight: 800;
            font-size: 18px;
            display: block;
            margin-bottom: 6px;
            letter-spacing: -0.5px;
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            gap: 5px;
            font-size: 12px;
            font-weight: 700;
            padding: 4px 10px;
            border-radius: 8px;
            letter-spacing: 0.3px;
        }

        .status-success { 
            background: rgba(16, 185, 129, 0.1);
            color: var(--success-color);
        }

        .status-pending { 
            background: rgba(245, 158, 11, 0.1);
            color: var(--pending-color);
        }

        .status-failed { 
            background: rgba(239, 68, 68, 0.1);
            color: var(--failed-color);
        }

        .status-badge i {
            font-size: 10px;
        }

        /* Empty State */
        .empty-state {
            text-align: center;
            padding: 60px 20px;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.8);
        }

        .empty-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 20px;
            background: linear-gradient(135deg, rgba(16, 185, 129, 0.1), rgba(5, 150, 105, 0.05));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 36px;
            color: var(--success-color);
        }

        .empty-text {
            color: var(--text-muted);
            font-size: 15px;
            font-weight: 500;
            line-height: 1.6;
        }

        .empty-text strong {
            display: block;
            color: #1f2937;
            font-size: 18px;
            font-weight: 700;
            margin-bottom: 8px;
        }

        /* Animation */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .record-card {
            animation: fadeInUp 0.4s ease-out backwards;
        }

        .record-card:nth-child(1) { animation-delay: 0.05s; }
        .record-card:nth-child(2) { animation-delay: 0.1s; }
        .record-card:nth-child(3) { animation-delay: 0.15s; }
        .record-card:nth-child(4) { animation-delay: 0.2s; }
        .record-card:nth-child(5) { animation-delay: 0.25s; }

        /* Responsive */
        @media (max-width: 480px) {
            .content-area {
                padding: 16px;
            }

            .record-card {
                padding: 14px;
                gap: 12px;
            }

            .icon-container {
                width: 48px;
                height: 48px;
                font-size: 20px;
            }

            .amount-positive {
                font-size: 16px;
            }

            .details-container b {
                font-size: 15px;
            }

            .summary-card {
                padding: 20px;
            }

            .summary-icon {
                width: 48px;
                height: 48px;
                font-size: 22px;
            }

            .summary-info p {
                font-size: 24px;
            }
        }
    </style>
</head>
<body>

<!-- Header -->
<div class="page-header">
    <a href="javascript:history.back()" class="back-arrow">
        <i class="fas fa-arrow-left"></i>
    </a>
    <div class="header-title">
        <div class="header-icon">
            <i class="fas fa-history"></i>
        </div>
        <span>Deposit History</span>
    </div>
    <div class="header-placeholder"></div>
</div>

<!-- Deposit Records List -->
<div class="content-area">
    <?php
        $deposits = class_exists('\App\Models\Deposit') 
            ? \App\Models\Deposit::where('user_id', auth()->id())->orderByDesc('id')->get() 
            : collect();
        
        $totalDeposited = $deposits->where('status', 'approved')->sum('amount');
    ?>

    <?php if($deposits->count() > 0): ?>
        <!-- Summary Card -->
        <div class="summary-card">
            <div class="summary-content">
                <div class="summary-left">
                    <div class="summary-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <div class="summary-info">
                        <h3>Total Deposited</h3>
                        <p>৳ <?php echo e(number_format($totalDeposited, 2)); ?></p>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="record-card" role="article">
            <!-- Icon on the left -->
            <div class="icon-container">
                <i class="fa-solid fa-wallet"></i>
            </div>
            
            <!-- Details in the middle -->
            <div class="details-container">
                <b>Deposit</b>
                <small>
                    <i class="fas fa-clock"></i>
                    <?php echo e(\Carbon\Carbon::parse($item->created_at)->format('d M, Y h:i A')); ?>

                </small>
            </div>

            <!-- Amount and Status on the right -->
            <div class="amount-container">
                <span class="amount-positive">+ ৳<?php echo e(number_format($item->amount, 2)); ?></span>
                
                <span class="status-badge 
                    <?php if($item->status == 'approved'): ?> status-success 
                    <?php elseif($item->status == 'pending'): ?> status-pending 
                    <?php else: ?> status-failed 
                    <?php endif; ?>">
                    <?php if($item->status == 'approved'): ?>
                        <i class="fas fa-check-circle"></i>
                    <?php elseif($item->status == 'pending'): ?>
                        <i class="fas fa-clock"></i>
                    <?php else: ?>
                        <i class="fas fa-times-circle"></i>
                    <?php endif; ?>
                    <?php echo e(ucfirst($item->status)); ?>

                </span>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="empty-state">
            <div class="empty-icon">
                <i class="fas fa-wallet"></i>
            </div>
            <div class="empty-text">
                <strong>No Deposits Yet</strong>
                You haven't made any deposit transactions yet.
            </div>
        </div>
    <?php endif; ?>
</div>

</body>
</html><?php /**PATH /home/khelawin124/trustwallet.dpdns.org/resources/views/app/main/deposit_record.blade.php ENDPATH**/ ?>