<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="theme-color" content="#e60012">

    <title>Gift Code — <?php echo e(env('APP_NAME')); ?></title>
    
    <link rel="icon" type="image/jpg" href="<?php echo e(asset('static/images/logo.jpg')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <style>
        :root {
            --brand-primary: #e60012;
            --brand-dark: #b3000e;
            --text-muted: #6b7280;
        }

        html { -webkit-text-size-adjust: 100%; }

        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e7e9ef 100%);
            min-height: 100vh;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            position: relative;
            margin: 0;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 200px;
            background: linear-gradient(135deg, var(--brand-primary) 0%, var(--brand-dark) 100%);
            z-index: 0;
        }

        .main-container {
            max-width: 500px;
            margin: 0 auto;
            position: relative;
            z-index: 1;
            min-height: 100vh;
            padding-bottom: 100px;
        }

        /* Header */
        .page-header {
            background: transparent;
            padding: 16px 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .header-title {
            color: #fff;
            font-weight: 700;
            font-size: 18px;
        }
        .header-placeholder { width: 40px; }

        /* Content */
        .content-wrapper {
            padding: 20px;
        }

        /* Redeem Card */
        .redeem-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 18px;
            padding: 22px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.8);
            margin-bottom: 20px;
            position: relative;
            overflow: hidden;
            text-align: center;
        }

        .redeem-icon {
            width: 80px;
            height: 80px;
            margin: 0 auto 20px;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 32px;
            box-shadow: 0 8px 20px rgba(230, 0, 18, 0.3);
        }

        .redeem-card h3 {
            font-size: 20px;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 8px;
        }

        .redeem-card p {
            font-size: 14px;
            color: var(--text-muted);
            margin-bottom: 24px;
        }

        .input-group {
            position: relative;
        }

        .redeem-input {
            width: 100%;
            height: 56px;
            background: #f9fafb;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            padding: 0 20px;
            font-size: 16px;
            color: #1f2937;
            font-weight: 600;
            outline: none;
            text-align: center;
            letter-spacing: 2px;
            text-transform: uppercase;
            transition: all 0.3s ease;
        }

        .redeem-input:focus {
            border-color: var(--brand-primary);
            background: #fff;
        }

        .redeem-btn {
            width: 100%;
            margin-top: 16px;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            color: #fff;
            border: none;
            border-radius: 12px;
            padding: 16px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .redeem-btn:hover {
            transform: scale(1.02);
            box-shadow: 0 6px 20px rgba(230, 0, 18, 0.4);
        }

        /* Info Card */
        .info-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 18px;
            padding: 22px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.8);
        }

        .info-header {
            display: flex; align-items: center; gap: 10px; margin-bottom: 18px;
        }
        .info-icon {
            width: 36px; height: 36px;
            background: linear-gradient(135deg, rgba(230, 0, 18, 0.1), rgba(179, 0, 14, 0.05));
            border-radius: 10px;
            display: flex; align-items: center; justify-content: center;
            color: var(--brand-primary); font-size: 16px;
        }
        .info-header h3 { font-size: 16px; font-weight: 700; color: #1f2937; }
        .info-steps { display: flex; flex-direction: column; gap: 14px; }
        .info-step { display: flex; align-items: flex-start; gap: 12px; }
        .step-number {
            width: 28px; height: 28px;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            color: #fff; border-radius: 8px;
            display: flex; align-items: center; justify-content: center;
            font-weight: 700; font-size: 13px; flex-shrink: 0;
            box-shadow: 0 4px 12px rgba(230, 0, 18, 0.25);
        }
        .step-text { font-size: 14px; color: #4b5563; line-height: 1.6; flex: 1; }
        .step-text strong { color: #1f2937; font-weight: 700; }

        /* Bottom Navigation */
        .bottom-nav {
            position: fixed; bottom: 0; left: 0; right: 0;
            max-width: 500px; margin: 0 auto; height: 72px;
            background: rgba(255, 255, 255, 0.98); backdrop-filter: blur(20px);
            box-shadow: 0 -8px 32px rgba(0, 0, 0, 0.08);
            border-top: 1px solid rgba(230, 0, 18, 0.1);
            z-index: 1000;
        }
        .nav-wrapper { display: flex; justify-content: space-around; align-items: center; height: 100%; padding: 0 10px; }
        .nav-item {
            flex: 1; display: flex; flex-direction: column; align-items: center; justify-content: center;
            text-decoration: none; color: var(--text-muted); transition: all 0.3s ease; position: relative;
            padding: 8px; border-radius: 12px;
        }
        .nav-item:hover { background: rgba(230, 0, 18, 0.05); }
        .nav-item.active { color: var(--brand-primary); background: rgba(230, 0, 18, 0.08); }
        .nav-item i { font-size: 22px; margin-bottom: 4px; }
        .nav-item span { font-size: 11px; font-weight: 600; letter-spacing: 0.3px; }
        .active-indicator {
            position: absolute; bottom: 0; left: 50%; transform: translateX(-50%);
            width: 40%; height: 3px;
            background: linear-gradient(90deg, var(--brand-primary), var(--brand-dark));
            border-radius: 3px 3px 0 0; opacity: 0; transition: opacity 0.3s ease;
        }
        .nav-item.active .active-indicator { opacity: 1; }

    </style>
</head>
<body>
    <div class="main-container">
        <!-- Header -->
        <header class="page-header">
            <a href="javascript:history.back()" class="notification-btn" style="color:white; text-decoration: none; display: flex; align-items: center; justify-content: center;">
                <i class="fas fa-arrow-left"></i>
            </a>
            <h1 class="header-title">Gift Code</h1>
            <div class="header-placeholder"></div>
        </header>

        <main class="content-wrapper">
            <!-- Redeem Card -->
            <div class="redeem-card">
                <div class="redeem-icon">
                    <i class="fas fa-gift"></i>
                </div>
                <h3>Redeem Your Gift Code</h3>
                <p>Enter your gift code below to claim special rewards.</p>
                
                <form action="<?php echo e(route('submitBonusCode')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="input-group">
                        <input type="text" name="bonus_code" class="redeem-input" placeholder="ENTER GIFT CODE" required>
                    </div>
                    <button type="submit" class="redeem-btn">Redeem Now</button>
                </form>
            </div>

            <!-- How It Works Card -->
            <div class="info-card">
                <div class="info-header">
                    <div class="info-icon">
                        <i class="fas fa-circle-info"></i>
                    </div>
                    <h3>How to get gift codes?</h3>
                </div>
                <div class="info-steps">
                    <div class="info-step">
                        <div class="step-number">1</div>
                        <div class="step-text">Buy any premium plan to get daily gift codes.</div>
                    </div>
                    <div class="info-step">
                        <div class="step-number">2</div>
                        <div class="step-text">Join our <strong>Telegram channel</strong> for special codes.</div>
                    </div>
                    <div class="info-step">
                        <div class="step-number">3</div>
                        <div class="step-text">Each code can be used <strong>only once</strong>.</div>
                    </div>
                </div>
            </div>
        </main>
    </div>

    <!-- Bottom Navigation -->
    <nav class="bottom-nav">
        <div class="nav-wrapper">
            <?php
                $nav_items = [
                    ['path' => 'dashboard', 'icon' => 'fas fa-home', 'label' => 'Home'],
                    ['path' => 'vip', 'icon' => 'fas fa-briefcase', 'label' => 'Plans'],
                    ['path' => 'my-team', 'icon' => 'fas fa-users', 'label' => 'Team'],
                    ['path' => 'my-profile', 'icon' => 'fas fa-user', 'label' => 'Profile'],
                ];
            ?>
            <?php $__currentLoopData = $nav_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(url($item['path'])); ?>" class="nav-item <?php echo e(request()->is($item['path']) || request()->is($item['path'].'/*') ? 'active' : ''); ?>">
                <i class="<?php echo e($item['icon']); ?>"></i>
                <span><?php echo e($item['label']); ?></span>
                <?php if(request()->is($item['path']) || request()->is($item['path'].'/*')): ?>
                    <div class="active-indicator"></div>
                <?php endif; ?>
            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </nav>
    
    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            toastr.options = { 
                "closeButton": true, 
                "progressBar": true, 
                "positionClass": "toast-top-right",
                "timeOut": "3000",
            };

            <?php if(session('success')): ?>
                toastr.success("<?php echo e(session('success')); ?>");
            <?php endif; ?>
            <?php if(session('error')): ?>
                toastr.error("<?php echo e(session('error')); ?>");
            <?php endif; ?>
        });
    </script>
</body>
</html><?php /**PATH /home/khelawin124/trustwallet.dpdns.org/resources/views/app/main/promo.blade.php ENDPATH**/ ?>