<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    
    <title><?php echo e(env('APP_NAME')); ?> | Recharge</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" type="image/jpg" href="<?php echo e(asset('static/images/logo.jpg')); ?>">
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    
    <style>
        :root {
            --brand-primary: #e60012;
            --brand-dark: #b3000e;
            --text-muted: #6b7280;
            --card-shadow: 0 8px 25px rgba(179, 0, 14, 0.08);
            --success-color: #10b981;
            --failed-color: #ef4444;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html {
            -webkit-text-size-adjust: 100%;
        }

        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e7e9ef 100%);
            min-height: 100vh;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            -webkit-font-smoothing: antialiased;
            position: relative;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 280px;
            background: linear-gradient(135deg, var(--brand-primary) 0%, var(--brand-dark) 100%);
            z-index: 0;
        }

        .main-container {
            max-width: 500px;
            margin: 0 auto;
            position: relative;
            z-index: 1;
        }

        /* Header */
        .page-header {
            background: transparent;
            color: #fff;
            padding: 0 20px;
            height: 60px;
            font-size: 20px;
            font-weight: 700;
            position: relative;
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .back-arrow {
            color: #fff;
            font-size: 22px;
            text-decoration: none;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: none;
            cursor: pointer;
        }

        .back-arrow:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateX(-3px);
        }
        
        .header-placeholder {
            width: 32px;
        }

        .header-title {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .header-icon {
            width: 36px;
            height: 36px;
            background: rgba(255, 255, 255, 0.15);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            backdrop-filter: blur(10px);
        }

        /* Content */
        .content-wrapper {
            padding: 20px;
        }

        /* Balance Card */
        .balance-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            padding: 28px;
            margin-bottom: 24px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.8);
            position: relative;
            overflow: hidden;
        }

        .balance-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--brand-primary), var(--brand-dark));
        }

        .balance-card::after {
            content: '';
            position: absolute;
            top: -50%;
            right: -20%;
            width: 200px;
            height: 200px;
            background: radial-gradient(circle, rgba(230, 0, 18, 0.08) 0%, transparent 70%);
            border-radius: 50%;
        }

        .balance-label {
            font-size: 14px;
            color: var(--text-muted);
            font-weight: 600;
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            gap: 8px;
            position: relative;
            z-index: 1;
        }

        .balance-amount {
            font-size: 42px;
            font-weight: 800;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            position: relative;
            z-index: 1;
            letter-spacing: -1px;
        }

        /* Form Sections */
        .form-section {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.8);
            padding: 24px;
            margin-bottom: 20px;
        }

        .section-title {
            font-size: 16px;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 16px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .section-title i {
            width: 32px;
            height: 32px;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 14px;
        }

        /* Preset Buttons */
        .preset-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 12px;
        }

        .preset-btn {
            border: 2px solid #e5e7eb;
            background: #ffffff;
            color: #1f2937;
            padding: 16px 12px;
            border-radius: 14px;
            font-weight: 700;
            font-size: 15px;
            cursor: pointer;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .preset-btn::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(230, 0, 18, 0.1);
            transform: translate(-50%, -50%);
            transition: width 0.4s ease, height 0.4s ease;
        }

        .preset-btn:hover {
            border-color: var(--brand-primary);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(230, 0, 18, 0.15);
        }

        .preset-btn:hover::before {
            width: 200px;
            height: 200px;
        }

        .preset-btn.selected {
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            color: white;
            border-color: var(--brand-primary);
            transform: scale(1.05);
            box-shadow: 0 8px 24px rgba(230, 0, 18, 0.3);
        }

        .preset-btn:active {
            transform: scale(0.98);
        }

        /* Custom Amount Input */
        .input-wrapper {
            position: relative;
            margin-top: 20px;
        }

        .input-label {
            font-weight: 600;
            color: #1f2937;
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
            margin-bottom: 10px;
        }

        .input-label i {
            color: var(--brand-primary);
            font-size: 16px;
        }

        .currency-symbol {
            position: absolute;
            left: 18px;
            top: 50%;
            transform: translateY(-50%);
            font-weight: 800;
            font-size: 20px;
            color: var(--brand-primary);
            pointer-events: none;
            z-index: 1;
        }

        .amount-input {
            width: 100%;
            height: 58px;
            padding: 0 18px 0 48px;
            border: 2px solid #e5e7eb;
            border-radius: 14px;
            background: #ffffff;
            font-size: 18px;
            font-weight: 700;
            color: #1f2937;
            outline: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .amount-input::placeholder {
            color: #9ca3af;
            font-weight: 500;
        }

        .amount-input:focus {
            border-color: var(--brand-primary);
            background: #ffffff;
            box-shadow: 0 0 0 4px rgba(230, 0, 18, 0.1);
            transform: translateY(-2px);
        }

        .amount-input:hover {
            border-color: #fca5a5;
        }

        /* Recharge Button */
        .btn-recharge {
            width: 100%;
            height: 58px;
            font-size: 17px;
            font-weight: 700;
            color: #fff;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            border: none;
            border-radius: 16px;
            cursor: pointer;
            margin-top: 24px;
            box-shadow: 0 10px 30px rgba(230, 0, 18, 0.35);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            letter-spacing: 0.5px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 12px;
        }

        .btn-recharge::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.5s ease;
        }

        .btn-recharge:hover::before {
            left: 100%;
        }

        .btn-recharge:hover {
            transform: translateY(-3px);
            box-shadow: 0 14px 40px rgba(230, 0, 18, 0.45);
        }

        .btn-recharge:active {
            transform: translateY(-1px);
        }

        .btn-recharge i {
            transition: transform 0.3s ease;
        }

        .btn-recharge:hover i {
            transform: translateX(4px);
        }

        /* Instructions Box */
        .info-box {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 16px;
            padding: 20px;
            border-left: 4px solid var(--brand-primary);
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.06);
        }

        .info-title {
            font-weight: 700;
            color: var(--brand-dark);
            font-size: 15px;
            margin-bottom: 12px;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .info-title i {
            font-size: 16px;
        }

        .info-list {
            list-style: none;
            padding: 0;
        }

        .info-list li {
            font-size: 14px;
            color: #4b5563;
            line-height: 1.7;
            margin-bottom: 8px;
            padding-left: 24px;
            position: relative;
        }

        .info-list li::before {
            content: '\f058';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            left: 0;
            color: var(--brand-primary);
            font-size: 14px;
        }

        .info-list strong {
            color: var(--brand-dark);
            font-weight: 700;
        }
        
        /* Alert Message */
        .alert-message {
            padding: 16px;
            margin-bottom: 20px;
            border-radius: 12px;
            font-size: 14px;
            font-weight: 500;
            border: 1px solid transparent;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .alert-danger {
            color: #92400e;
            background-color: #fffbeb;
            border-color: #fde68a;
        }

        /* Animation */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .page-transition {
            animation: fadeIn 0.5s ease-out;
        }

        /* Loading State */
        .btn-recharge:disabled {
            cursor: not-allowed;
            background: #d1d5db;
            box-shadow: none;
        }
        .btn-recharge:disabled .btn-text {
            margin-right: 10px;
        }
        .spinner {
            border: 3px solid rgba(255,255,255,0.3);
            border-top: 3px solid #fff;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }


        /* Responsive */
        @media (max-width: 480px) {
            .content-wrapper {
                padding: 16px;
            }
            .balance-card,
            .form-section,
            .info-box {
                padding: 20px 18px;
            }
            .balance-amount {
                font-size: 36px;
            }
            .preset-grid {
                gap: 10px;
            }
            .preset-btn {
                padding: 14px 10px;
                font-size: 14px;
            }
        }
    </style>
</head>
<body class="page-transition">
    
    <div class="main-container">
        
        <!-- Header -->
        <div class="page-header">
            <button onclick="window.history.back()" class="back-arrow">
                <i class="fas fa-arrow-left"></i>
            </button>
            <div class="header-title">
                <div class="header-icon">
                    <i class="fas fa-wallet"></i>
                </div>
                <span>Recharge</span>
            </div>
            <div class="header-placeholder"></div>
        </div>

        <main class="content-wrapper">
            <!-- Balance Display Card -->
            <div class="balance-card">
                <div class="balance-label">
                    <i class="fas fa-coins"></i>
                    Current Balance
                </div>
                <div class="balance-amount">৳ <?php echo e(number_format(auth()->user()->balance, 2)); ?></div>
            </div>

            <!-- Display Error Messages -->
            <?php if(session('error')): ?>
                <div class="alert-message alert-danger">
                    <i class="fas fa-exclamation-triangle"></i>
                    <span><?php echo e(session('error')); ?></span>
                </div>
            <?php endif; ?>
            <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                 <div class="alert-message alert-danger">
                    <i class="fas fa-exclamation-triangle"></i>
                    <span><?php echo e($message); ?></span>
                </div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            
            <!-- NAGORIKPAY FORM -->
            <form id="rechargeForm" action="<?php echo e(route('nagorikpay.pay')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <!-- Preset Amounts Section -->
                <div class="form-section">
                    <div class="section-title">
                        <i class="fas fa-hand-pointer"></i>
                        Choose an Amount
                    </div>
                    <div class="preset-grid">
                        <?php $__currentLoopData = [1000, 3000, 5000, 10000, 2000, 25000]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $amount): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button type="button" class="preset-btn" onclick="setAmount(<?php echo e($amount); ?>)">
                            ৳<?php echo e(number_format($amount)); ?>

                        </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Custom Amount Input Section -->
                <div class="form-section">
                    <div class="input-wrapper">
                        <label for="amount" class="input-label">
                            <i class="fas fa-edit"></i>
                            Or Enter Custom Amount
                        </label>
                        <div style="position: relative;">
                            <div class="currency-symbol">৳</div>
                            <input id="amount" 
                                   name="amount" 
                                   type="number" 
                                   inputmode="numeric" 
                                   min="1000" 
                                   placeholder="Minimum 1000"
                                   class="amount-input"
                                   aria-label="Amount"
                                   required />
                        </div>
                    </div>

                    <!-- Recharge Button -->
                    <button type="submit" id="rechargeButton" class="btn-recharge">
                        <span class="btn-text">Recharge Now</span>
                        <i class="fas fa-arrow-right"></i>
                    </button>
                </div>
            </form>

            <!-- Instructions Box -->
            <div class="info-box">
                <div class="info-title">
                    <i class="fas fa-info-circle"></i>
                    Recharge Instructions
                </div>
                <ul class="info-list">
                    <li>Minimum deposit is <strong>1000 ৳</strong></li>
                    <li>Funds reflect within <strong>5–10 minutes</strong> after successful payment</li>
                    <li>If not credited within 30 minutes, contact Customer Service</li>
                </ul>
            </div>
        </main>
    </div>

    <script>
        const amountInput = document.getElementById('amount');
        const rechargeForm = document.getElementById('rechargeForm');
        const rechargeButton = document.getElementById('rechargeButton');

        function setAmount(value) {
            // Remove 'selected' class from all buttons
            document.querySelectorAll('.preset-btn').forEach(btn => btn.classList.remove('selected'));
            
            // Find the button that was clicked and add 'selected'
            const buttons = Array.from(document.querySelectorAll('.preset-btn'));
            const targetBtn = buttons.find(btn => btn.textContent.includes(String(value).replace(/\B(?=(\d{3})+(?!\d))/g, ",")));
            if (targetBtn) {
                targetBtn.classList.add('selected');
            }
            
            // Set the value in the input field
            if (amountInput) {
                amountInput.value = value;
            }
        }

        // Handle form submission
        rechargeForm.addEventListener('submit', function(event) {
            // 1. Prevent the form from submitting immediately
            event.preventDefault();

            // 2. Validate the amount
            const amount = parseInt(amountInput.value, 10);
            if (!amountInput.value || isNaN(amount) || amount < 1000) {
                alert("Minimum recharge amount is 1000 ৳.");
                return;
            }

            // 3. Show loading state on the button
            rechargeButton.disabled = true;
            rechargeButton.innerHTML = `<span class="btn-text">Processing...</span> <div class="spinner"></div>`;

            // 4. Submit the form
            this.submit();
        });

        // Clear selection when user types custom amount
        amountInput.addEventListener('input', function() {
            if (this.value) {
                document.querySelectorAll('.preset-btn').forEach(btn => btn.classList.remove('selected'));
            }
        });
    </script>
</body>
</html><?php /**PATH /home/khelawin124/trustwallet.dpdns.org/resources/views/app/main/recharge/index.blade.php ENDPATH**/ ?>