<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    
    <title>My Profile — <?php echo e(env('APP_NAME')); ?></title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" type="image/jpg" href="<?php echo e(asset('static/images/logo.jpg')); ?>">
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    
    <style>
        :root {
            --brand-primary: #e60012;
            --brand-dark: #b3000e;
            --text-muted: #6b7280;
            --card-shadow: 0 8px 25px rgba(179, 0, 14, 0.08);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html {
            -webkit-text-size-adjust: 100%;
        }

        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e7e9ef 100%);
            min-height: 100vh;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            -webkit-font-smoothing: antialiased;
            position: relative;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 200px;
            background: linear-gradient(135deg, var(--brand-primary) 0%, var(--brand-dark) 100%);
            z-index: 0;
        }

        .main-container {
            max-width: 500px;
            margin: 0 auto;
            position: relative;
            z-index: 1;
            min-height: 100vh;
            padding-bottom: 100px;
        }

        /* Header */
        .page-header {
            background: transparent;
            padding: 16px 20px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            position: relative;
            z-index: 1000;
        }

        .logo-section { 
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .logo-circle {
            width: 44px;
            height: 44px;
            background: rgba(255, 255, 255, 0.95);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        }

        .logo-circle img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .logo-text {
            display: flex;
            flex-direction: column;
        }

        .logo-text .main {
            color: #fff;
            font-weight: 700;
            font-size: 16px;
            line-height: 1.2;
        }

        .logo-text .sub {
            color: rgba(255, 255, 255, 0.8);
            font-size: 10px;
            font-weight: 600;
            letter-spacing: 0.5px;
        }

        .help-btn {
            width: 40px;
            height: 40px;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: none;
            border-radius: 10px;
            color: #fff;
            font-size: 20px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .help-btn:hover {
            background: rgba(255, 255, 255, 0.2);
        }

        /* Content */
        .content-wrapper {
            padding: 20px;
        }

        /* Profile Card */
        .profile-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 22px;
            padding: 28px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.8);
            margin-bottom: 20px;
            position: relative;
            overflow: hidden;
        }

        .profile-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(90deg, var(--brand-primary), var(--brand-dark));
        }

        .profile-card::after {
            content: '';
            position: absolute;
            bottom: -100px;
            right: -100px;
            width: 250px;
            height: 250px;
            background: radial-gradient(circle, rgba(230, 0, 18, 0.05) 0%, transparent 70%);
            border-radius: 50%;
        }

        .profile-header {
            display: flex;
            align-items: center;
            gap: 18px;
            margin-bottom: 24px;
            position: relative;
            z-index: 1;
        }

        .profile-avatar {
            width: 72px;
            height: 72px;
            border-radius: 50%;
            background: linear-gradient(135deg, rgba(230, 0, 18, 0.1), rgba(179, 0, 14, 0.05));
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            cursor: pointer;
            overflow: hidden;
            border: 3px solid rgba(230, 0, 18, 0.2);
            transition: all 0.3s ease;
        }

        .profile-avatar:hover {
            transform: scale(1.05);
            border-color: var(--brand-primary);
        }

        .profile-avatar img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 50%;
        }

        .profile-info {
            flex: 1;
        }

        .profile-name {
            font-size: 20px;
            font-weight: 800;
            color: #1f2937;
            margin-bottom: 4px;
        }

        .profile-id {
            font-size: 13px;
            color: var(--text-muted);
            font-weight: 600;
        }

        .balance-section {
            background: linear-gradient(135deg, rgba(230, 0, 18, 0.08), rgba(230, 0, 18, 0.03));
            border-radius: 16px;
            padding: 20px;
            text-align: center;
            position: relative;
            z-index: 1;
        }

        .balance-label {
            font-size: 13px;
            color: var(--text-muted);
            font-weight: 600;
            margin-bottom: 8px;
        }

        .balance-amount {
            font-size: 36px;
            font-weight: 800;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            letter-spacing: -1px;
        }

        /* Action Buttons */
        .action-buttons {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 16px;
            margin-bottom: 24px;
        }

        .action-btn {
            text-decoration: none;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 10px;
        }

        .action-icon {
            width: 68px;
            height: 68px;
            border-radius: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            font-size: 26px;
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.15);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .action-icon::before {
            content: '';
            position: absolute;
            top: -50%;
            right: -50%;
            width: 100%;
            height: 100%;
            background: radial-gradient(circle, rgba(255, 255, 255, 0.2) 0%, transparent 70%);
            border-radius: 50%;
        }

        .action-icon:hover {
            transform: translateY(-4px) scale(1.05);
            box-shadow: 0 12px 32px rgba(0, 0, 0, 0.2);
        }

        .action-icon.orange {
            background: linear-gradient(135deg, #fb923c, #f97316);
        }

        .action-icon.cyan {
            background: linear-gradient(135deg, #22d3ee, #3b82f6);
        }

        .action-icon.indigo {
            background: linear-gradient(135deg, #6366f1, #3b82f6);
        }

        .action-label {
            font-size: 13px;
            font-weight: 600;
            color: #4b5563;
        }

        /* Options Section */
        .section-title {
            font-size: 16px;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 16px;
            padding: 0 4px;
        }

        .options-list {
            display: flex;
            flex-direction: column;
            gap: 12px;
            margin-bottom: 24px;
        }

        .option-item {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 16px;
            padding: 16px 18px;
            display: flex;
            align-items: center;
            gap: 14px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.06);
            border: 1px solid rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: all 0.3s ease;
        }

        .option-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 24px rgba(0, 0, 0, 0.1);
            background: rgba(255, 255, 255, 1);
        }

        .option-icon {
            width: 40px;
            height: 40px;
            border-radius: 10px;
            background: #f3f4f6;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--brand-primary);
            font-size: 18px;
        }

        .option-arrow {
            margin-left: auto;
            color: #d1d5db;
            font-size: 12px;
        }

        .logout-btn {
            width: 100%;
            padding: 16px;
            border-radius: 16px;
            background: #fff;
            color: #ef4444;
            font-weight: 700;
            border: 1px solid #fee2e2;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 20px;
        }

        .logout-btn:hover {
            background: #fef2f2;
            transform: translateY(-2px);
        }

        /* Bottom Nav */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(20px);
            padding: 12px 24px;
            padding-bottom: calc(12px + env(safe-area-inset-bottom));
            border-top: 1px solid rgba(0, 0, 0, 0.05);
            z-index: 1000;
        }

        .nav-wrapper {
            max-width: 500px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 4px;
            text-decoration: none;
            color: #9ca3af;
            font-size: 11px;
            font-weight: 600;
            transition: all 0.3s ease;
            position: relative;
        }

        .nav-item.active {
            color: var(--brand-primary);
        }

        .nav-item i {
            font-size: 20px;
        }

        .active-indicator {
            position: absolute;
            top: -12px;
            width: 20px;
            height: 3px;
            background: var(--brand-primary);
            border-radius: 0 0 4px 4px;
        }

        /* Modal */
        .modal {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0, 0, 0, 0.5);
            display: none;
            align-items: center;
            justify-content: center;
            z-index: 2000;
            padding: 20px;
            backdrop-filter: blur(5px);
        }

        .modal.show {
            display: flex;
        }

        .modal-content {
            background: #fff;
            border-radius: 24px;
            padding: 32px;
            width: 100%;
            max-width: 400px;
            text-align: center;
            transform: scale(0.9);
            transition: transform 0.3s ease;
        }

        .modal.show .modal-content {
            transform: scale(1);
        }

        .modal-title {
            font-size: 20px;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 12px;
        }

        .modal-text {
            font-size: 14px;
            color: var(--text-muted);
            margin-bottom: 24px;
            line-height: 1.6;
        }

        .modal-buttons {
            display: flex;
            gap: 12px;
        }

        .modal-btn {
            flex: 1;
            padding: 12px;
            border-radius: 12px;
            font-weight: 600;
            font-size: 14px;
            cursor: pointer;
            transition: all 0.3s ease;
            border: none;
        }

        .modal-btn.cancel {
            background: #f3f4f6;
            color: #4b5563;
        }

        .modal-btn.cancel:hover {
            background: #e5e7eb;
        }

        .modal-btn.confirm {
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            color: #fff;
        }

        .modal-btn.confirm:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(230, 0, 18, 0.3);
        }

        /* Animation */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .page-transition {
            animation: fadeIn 0.5s ease-out;
        }

        /* Responsive */
        @media (max-width: 480px) {
            .content-wrapper {
                padding: 16px;
            }

            .profile-card {
                padding: 24px 20px;
            } 

            .balance-amount {
                font-size: 32px;
            }

            .action-icon {
                width: 62px;
                height: 62px;
                font-size: 24px;
            }
        }
    </style>
</head>
<body class="page-transition">
    
    <div class="main-container">
        
        <!-- Header -->
        <header class="page-header">
            <div class="logo-section">
                <div class="logo-circle">
                    <a href="<?php echo e(url('dashboard')); ?>" style="display: block; width: 100%; height: 100%;">
                        <img src="https://i.postimg.cc/qMX2HKS6/IMG-20260121-WA0002.jpg" alt="Logo">
                    </a>
                </div>
                <div class="logo-text">
                    <span class="main">Trust Wallet Official</span>
                    <span class="sub">INDUSTRIES LIMITED</span>
                </div>
            </div>
            <button class="help-btn" onclick="navigate('<?php echo e(url('/service')); ?>')">
                <i class="fa fa-headphones"></i>
            </button>
        </header>

        <main class="content-wrapper">
            <!-- User Info Card -->
            <div class="profile-card">
                <div class="profile-header">
                    <div class="profile-avatar" onclick="uploadProfile()">
                        <img id="profileImage" src="<?php echo e(auth()->user()->profile_photo_url ?? asset('images/default-avatar.png')); ?>" alt="Profile Picture">
                    </div>
                    <div class="profile-info">
                        <div class="profile-name"><?php echo e(auth()->user()->name); ?></div>
                        <div class="profile-id">ID: <?php echo e(auth()->user()->phone); ?></div>
                    </div>
                </div>
                <div class="balance-section">
                    <div class="balance-label">Account Balance</div>
                    <div class="balance-amount"><?php echo e(price(auth()->user()->balance, 2)); ?></div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="action-buttons">
                <?php
                    $actions = [
                        ['url' => url('user/recharge'), 'icon' => 'fas fa-credit-card', 'label' => 'Recharge', 'class' => 'orange'],
                        ['url' => url('withdraw'), 'icon' => 'fas fa-money-bill-transfer', 'label' => 'Withdraw', 'class' => 'cyan'],
                        ['url' => url('history'), 'icon' => 'fas fa-clipboard-list', 'label' => 'History', 'class' => 'indigo'],
                    ];
                ?>
                <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e($action['url']); ?>" class="action-btn">
                    <div class="action-icon <?php echo e($action['class']); ?>">
                        <i class="<?php echo e($action['icon']); ?>"></i>
                    </div>
                    <span class="action-label"><?php echo e($action['label']); ?></span>
                </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Options List -->
            <h3 class="section-title">More Options</h3>
            <div class="options-list">
                <?php
                    $options = [
                        ['url' => url('/my/vip'), 'icon' => 'fa fa-box-open', 'label' => 'Order'],
                        ['url' => url('/promo'), 'icon' => 'fa fa-gift', 'label' => 'Bonus'],
                        ['url' => url('/deposit/record'), 'icon' => 'fa fa-file-invoice-dollar', 'label' => 'Deposit Record'],
                        ['url' => url('/withdraw/record'), 'icon' => 'fa fa-money-bill-wave', 'label' => 'Withdrawal Record'],
                        ['url' => url('/add/card'), 'icon' => 'fa fa-credit-card', 'label' => 'Withdrawal Wallet'],
                        ['url' => url('/about-us'), 'icon' => 'fa fa-info-circle', 'label' => 'About Us'],
                        ['url' => asset('app/base.apk'), 'icon' => 'fa fa-download', 'label' => 'App Download'],
                    ];
                ?>

                <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e($option['url']); ?>" class="option-item">
                    <div class="option-icon">
                        <i class="<?php echo e($option['icon']); ?>"></i>
                    </div>
                    <span class="option-label"><?php echo e($option['label']); ?></span>
                    <i class="fas fa-chevron-right option-arrow"></i>
                </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <!-- Logout Button -->
            <button onclick="openLogoutModal()" class="logout-btn">
                Log Out
            </button>
        </main>
    </div>

    <!-- Bottom Navigation -->
    <nav class="bottom-nav">
        <div class="nav-wrapper">
            <?php
                $nav_items = [
                    ['path' => 'dashboard', 'icon' => 'fas fa-home', 'label' => 'Home'],
                    ['path' => 'vip', 'icon' => 'fas fa-briefcase', 'label' => 'Plans'],
                    ['path' => 'my-team', 'icon' => 'fas fa-users', 'label' => 'Team'],
                    ['path' => 'my-profile', 'icon' => 'fas fa-user', 'label' => 'Profile'],
                ];
            ?>
            <?php $__currentLoopData = $nav_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(url($item['path'])); ?>" class="nav-item <?php echo e(request()->is($item['path']) ? 'active' : ''); ?>">
                <i class="<?php echo e($item['icon']); ?>"></i>
                <span><?php echo e($item['label']); ?></span>
                <?php if(request()->is($item['path'])): ?>
                    <div class="active-indicator"></div>
                <?php endif; ?>
            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </nav>

    <!-- Logout confirmation modal -->
    <div id="logoutModal" class="modal">
        <div class="modal-content">
            <h3 class="modal-title">Confirm Logout</h3>
            <p class="modal-text">Are you sure you want to log out?</p>
            <div class="modal-buttons">
                <button onclick="closeLogoutModal()" class="modal-btn cancel">Cancel</button>
                <button id="confirmLogoutBtn" class="modal-btn confirm">Log out</button>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    
    <script>
        // Setup CSRF token for all AJAX requests
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        document.addEventListener('DOMContentLoaded', function() {
            toastr.options = { "closeButton": true, "progressBar": true, "positionClass": "toast-top-right" };
            <?php if(session('success')): ?>
                toastr.success("<?php echo e(session('success')); ?>");
            <?php endif; ?>
            <?php if(session('error')): ?>
                toastr.error("<?php echo e(session('error')); ?>");
            <?php endif; ?>
        });
        
        // Navigation helper
        function navigate(path) {
            window.location.href = path;
        }

        // Logout modal functions
        function openLogoutModal() {
            document.getElementById('logoutModal').classList.add('show');
        }
        
        function closeLogoutModal() {
            document.getElementById('logoutModal').classList.remove('show');
        }

        // Handle logout confirmation
        document.getElementById('confirmLogoutBtn').addEventListener('click', function() {
            this.disabled = true;
            this.textContent = 'Logging out...';
            navigate('<?php echo e(url('/logout')); ?>'); 
        });

        // Profile picture upload function
        function uploadProfile() {
            let input = document.createElement("input");
            input.accept = ".png,.jpg,.jpeg";
            input.type = "file";
            input.onchange = function () {
                const file = input.files[0];
                if (file) {
                    const reader = new FileReader();
                    reader.onload = () => {
                        const base64String = reader.result.split(",")[1];
                        document.getElementById('profileImage').src = "data:image/png;base64," + base64String;
                        
                        $.post("<?php echo e(url('/home/upload_profile_image')); ?>", { data: base64String })
                            .done(function() {
                                toastr.success("Profile image updated!");
                            })
                            .fail(function() {
                                toastr.error("Failed to update image.");
                            });
                    };
                    reader.readAsDataURL(file);
                }
            }
            input.click();
        }

        // Close modal on outside click
        document.getElementById('logoutModal').addEventListener('click', function(e) {
            if (e.target === this) {
                closeLogoutModal();
            }
        });
    </script>
</body>
</html>
<?php /**PATH /home/khelawin124/trustwallet.dpdns.org/resources/views/app/main/profile.blade.php ENDPATH**/ ?>