<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    
    <title><?php echo e(env('APP_NAME')); ?> | Withdrawal</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" type="image/jpg" href="<?php echo e(asset('static/images/logo.jpg')); ?>">
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
    
    <style>
        :root {
            --brand-primary: #e60012;
            --brand-dark: #b3000e;
            --text-muted: #6b7280;
            --card-shadow: 0 8px 25px rgba(179, 0, 14, 0.08);
            --success-color: #10b981;
            --failed-color: #ef4444;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html {
            -webkit-text-size-adjust: 100%;
        }

        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e7e9ef 100%);
            min-height: 100vh;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            -webkit-font-smoothing: antialiased;
            position: relative;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 280px;
            background: linear-gradient(135deg, var(--brand-primary) 0%, var(--brand-dark) 100%);
            z-index: 0;
        }

        .main-container {
            max-width: 500px;
            margin: 0 auto;
            position: relative;
            z-index: 1;
        }

        /* Header */
        .page-header {
            background: transparent;
            color: #fff;
            padding: 0 20px;
            height: 60px;
            font-size: 20px;
            font-weight: 700;
            position: relative;
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .back-arrow {
            color: #fff;
            font-size: 22px;
            text-decoration: none;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: none;
            cursor: pointer;
        }

        .back-arrow:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateX(-3px);
        }
        
        .header-placeholder {
            width: 32px;
        }

        .header-title {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .header-icon {
            width: 36px;
            height: 36px;
            background: rgba(255, 255, 255, 0.15);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            backdrop-filter: blur(10px);
        }

        /* Content */
        .content-wrapper {
            padding: 20px;
        }

        /* Balance Card */
        .balance-card {
            background: rgba(255, 255, 255, 0.98);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            padding: 28px;
            margin-bottom: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.15);
            border: 1px solid rgba(255, 255, 255, 0.8);
            position: relative;
            overflow: hidden;
            text-align: center;
        }

        .balance-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--brand-primary), var(--brand-dark));
        }

        .balance-card::after {
            content: '';
            position: absolute;
            top: -50%;
            right: -20%;
            width: 200px;
            height: 200px;
            background: radial-gradient(circle, rgba(230, 0, 18, 0.08) 0%, transparent 70%);
            border-radius: 50%;
        }

        .balance-label {
            font-size: 14px;
            color: var(--text-muted);
            font-weight: 600;
            margin-bottom: 8px;
            position: relative;
            z-index: 1;
        }

        .balance-amount {
            font-size: 42px;
            font-weight: 800;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            position: relative;
            z-index: 1;
            letter-spacing: -1px;
        }

        /* Bank Info Card */
        .bank-info-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 18px;
            padding: 18px;
            margin-bottom: 20px;
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.8);
            display: flex;
            align-items: center;
            justify-content: space-between;
            transition: all 0.3s ease;
        }

        .bank-info-card:hover {
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.12);
            transform: translateY(-2px);
        }

        .bank-info-left {
            display: flex;
            align-items: center;
            gap: 14px;
        }

        .bank-icon-wrapper {
            width: 52px;
            height: 52px;
            background: linear-gradient(135deg, rgba(230, 0, 18, 0.1), rgba(179, 0, 14, 0.05));
            border-radius: 14px;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
        }

        .bank-icon-wrapper i {
            color: var(--brand-primary);
            font-size: 22px;
        }

        .bank-details h3 {
            font-size: 16px;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 4px;
        }

        .bank-details p {
            font-size: 13px;
            color: var(--text-muted);
            font-weight: 500;
        }

        .edit-link {
            color: var(--brand-primary);
            font-weight: 700;
            font-size: 14px;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 6px;
            padding: 8px 14px;
            border-radius: 10px;
            background: rgba(230, 0, 18, 0.05);
            transition: all 0.3s ease;
        }

        .edit-link:hover {
            background: rgba(230, 0, 18, 0.1);
            transform: translateX(2px);
        }

        .edit-link i {
            font-size: 13px;
        }

        /* Form Card */
        .form-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.8);
            padding: 26px;
            margin-bottom: 20px;
            position: relative;
            overflow: hidden;
        }

        .form-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--brand-primary), var(--brand-dark));
        }

        .form-label {
            font-weight: 700;
            color: #1f2937;
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 16px;
            margin-bottom: 14px;
        }

        .form-label i {
            color: var(--brand-primary);
            font-size: 18px;
        }

        .input-wrapper {
            position: relative;
            margin-bottom: 20px;
        }

        .currency-symbol {
            position: absolute;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            font-weight: 800;
            font-size: 24px;
            color: var(--brand-primary);
            pointer-events: none;
            z-index: 1;
        }

        .amount-input {
            width: 100%;
            height: 68px;
            padding: 0 20px 0 56px;
            border: 2px solid #e5e7eb;
            border-radius: 16px;
            background: #ffffff;
            font-size: 28px;
            font-weight: 800;
            color: #1f2937;
            outline: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            letter-spacing: -0.5px;
        }

        .amount-input::placeholder {
            color: #d1d5db;
            font-weight: 600;
        }

        .amount-input:focus {
            border-color: var(--brand-primary);
            background: #ffffff;
            box-shadow: 0 0 0 4px rgba(230, 0, 18, 0.1);
            transform: translateY(-2px);
        }

        .amount-input:hover {
            border-color: #fca5a5;
        }

        /* Withdraw Button */
        .btn-withdraw {
            width: 100%;
            height: 58px;
            font-size: 17px;
            font-weight: 700;
            color: #fff;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            border: none;
            border-radius: 16px;
            cursor: pointer;
            box-shadow: 0 10px 30px rgba(230, 0, 18, 0.35);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            letter-spacing: 0.5px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }

        .btn-withdraw::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.5s ease;
        }

        .btn-withdraw:hover::before {
            left: 100%;
        }

        .btn-withdraw:hover:not(:disabled) {
            transform: translateY(-3px);
            box-shadow: 0 14px 40px rgba(230, 0, 18, 0.45);
        }

        .btn-withdraw:active:not(:disabled) {
            transform: translateY(-1px);
        }

        .btn-withdraw:disabled {
            opacity: 0.5;
            cursor: not-allowed;
            background: #9ca3af;
            box-shadow: none;
        }

        .btn-withdraw i {
            transition: transform 0.3s ease;
        }

        .btn-withdraw:hover:not(:disabled) i {
            transform: translateX(4px);
        }

        /* Info Section */
        .info-section {
            margin-top: 24px;
        }

        .info-title {
            font-size: 16px;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 14px;
            padding: 0 4px;
        }

        .info-items {
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .info-item {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            padding: 16px;
            border-radius: 14px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.06);
            display: flex;
            align-items: flex-start;
            gap: 14px;
            border: 1px solid rgba(255, 255, 255, 0.8);
            transition: all 0.3s ease;
        }

        .info-item:hover {
            box-shadow: 0 6px 20px rgba(0, 0, 0, 0.1);
            transform: translateY(-2px);
        }

        .info-icon {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, rgba(230, 0, 18, 0.1), rgba(179, 0, 14, 0.05));
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            flex-shrink: 0;
        }

        .info-icon i {
            color: var(--brand-primary);
            font-size: 18px;
        }

        .info-content h4 {
            font-size: 15px;
            font-weight: 700;
            color: #1f2937;
            margin-bottom: 4px;
        }

        .info-content p {
            font-size: 13px;
            color: var(--text-muted);
            line-height: 1.5;
            font-weight: 500;
        }

        /* Animation */
        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .page-transition {
            animation: fadeIn 0.5s ease-out;
        }

        @keyframes pulse {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.5;
            }
        }

        /* Responsive */
        @media (max-width: 480px) {
            .content-wrapper {
                padding: 16px;
            }

            .balance-card,
            .bank-info-card,
            .form-card {
                padding: 20px 18px;
            }

            .balance-amount {
                font-size: 36px;
            }

            .amount-input {
                height: 62px;
                font-size: 24px;
                padding-left: 50px;
            }

            .currency-symbol {
                font-size: 22px;
                left: 18px;
            }

            .bank-icon-wrapper {
                width: 48px;
                height: 48px;
            }

            .bank-icon-wrapper i {
                font-size: 20px;
            }
        }

        /* Toastr custom styles */
        .toast-top-right {
            top: 20px;
            right: 20px;
        }
    </style>
</head>
<body class="page-transition">
    
    <div class="main-container">
        
        <!-- Header -->
        <div class="page-header">
            <button onclick="window.history.back()" class="back-arrow">
                <i class="fas fa-arrow-left"></i>
            </button>
            <div class="header-title">
                <div class="header-icon">
                    <i class="fas fa-hand-holding-dollar"></i>
                </div>
                <span>Withdraw Funds</span>
            </div>
            <div class="header-placeholder"></div>
        </div>

        <main class="content-wrapper">
            <form id="withdrawForm" action="<?php echo e(route('user.withdraw-confirm-submit')); ?>" method="POST">
                <?php echo csrf_field(); ?>

                <!-- Balance Card -->
                <div class="balance-card">
                    <div class="balance-label">Available Balance</div>
                    <div class="balance-amount"><?php echo e(price(auth()->user()->balance)); ?></div>
                </div>

                <?php
                    $method = class_exists('\App\Models\PaymentMethod') 
                        ? \App\Models\PaymentMethod::where('id', auth()->user()->gateway_method)->first() 
                        : null;
                ?>

                <!-- Bank Info Card -->
                <div class="bank-info-card">
                    <div class="bank-info-left">
                        <div class="bank-icon-wrapper">
                            <i class="fas fa-university"></i>
                        </div>
                        <div class="bank-details">
                            <h3><?php echo e($method->name ?? 'Not Set'); ?></h3>
                            <p><?php echo e(auth()->user()->gateway_number ?? 'Not Set'); ?></p>
                        </div>
                    </div>
                    <a href="/add/card" class="edit-link">
                        <i class="fas fa-edit"></i>
                        <span>Edit</span>
                    </a>
                </div>
                
                <!-- Withdrawal Form Card -->
                <div class="form-card">
                    <label class="form-label">
                        <i class="fas fa-money-bill-wave"></i>
                        Withdraw Amount
                    </label>
                    <div class="input-wrapper">
                        <div class="currency-symbol">৳</div>
                        <input id="amount" 
                               type="number" 
                               name="amount" 
                               class="amount-input" 
                               placeholder="0.00" 
                               min="350" 
                               step="0.01" 
                               required>
                    </div>
                    
                    <button type="button" id="withdrawBtn" class="btn-withdraw">
                        <i class="fas fa-paper-plane"></i>
                        <span>Withdraw Now</span>
                    </button>
                </div>

                <input type="hidden" name="account_id" value="<?php echo e(auth()->user()->gateway_number); ?>">
                <input type="hidden" id="last_withdrawal_date" value="">
            </form>

            <!-- Withdrawal Information -->
            <div class="info-section">
                <h3 class="info-title">Withdrawal Information</h3>
                <div class="info-items">
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div class="info-content">
                            <h4>Withdrawal Time</h4>
                            <p>10:00 AM to 10:00 PM (local time)</p>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-calendar-day"></i>
                        </div>
                        <div class="info-content">
                            <h4>Daily Limit</h4>
                            <p>You can withdraw only once per day</p>
                        </div>
                    </div>
                    <div class="info-item">
                        <div class="info-icon">
                            <i class="fas fa-coins"></i>
                        </div>
                        <div class="info-content">
                            <h4>Minimum Amount</h4>
                            <p>350 ৳</p>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            toastr.options = { 
                "closeButton": true, 
                "progressBar": true, 
                "positionClass": "toast-top-right",
                "timeOut": "3500"
            };

            const withdrawBtn = document.getElementById('withdrawBtn');
            let errorMsg = '';

            function isWithinAllowedHours() {
                const now = new Date();
                const hours = now.getHours();
                return hours >= 10 && hours < 22;
            }

            function hasWithdrawnToday() {
                const lastDateStr = document.getElementById('last_withdrawal_date').value;
                if (!lastDateStr) return false;
                const lastDate = new Date(lastDateStr.split(' ')[0]);
                const today = new Date();
                return lastDate.setHours(0,0,0,0) === today.setHours(0,0,0,0);
            }

            function updateButtonState() {
                if (!isWithinAllowedHours()) {
                    withdrawBtn.disabled = true;
                    errorMsg = 'Withdrawal is only allowed between 10 AM and 10 PM.';
                } else if (hasWithdrawnToday()) {
                    withdrawBtn.disabled = true;
                    errorMsg = 'You have already withdrawn today. Please try again tomorrow.';
                } else {
                    withdrawBtn.disabled = false;
                    errorMsg = '';
                }
            }

            withdrawBtn.addEventListener('click', function() {
                updateButtonState();
                if (this.disabled) {
                    toastr.error(errorMsg);
                    return;
                }

                const amount = parseFloat(document.getElementById('amount').value);
                if (!amount || amount < 350) {
                    toastr.error('Minimum withdrawal amount is 350 ৳.');
                    return;
                }
                
                document.getElementById('withdrawForm').submit();
            });

            // Keyboard support
            document.getElementById('amount').addEventListener('keypress', function(e) {
                if (e.key === 'Enter') {
                    e.preventDefault();
                    withdrawBtn.click();
                }
            });

            // Initial and periodic check
            updateButtonState();
            setInterval(updateButtonState, 60000);

            // Session flash messages
            <?php if(session('success')): ?>
                toastr.success("<?php echo e(session('success')); ?>");
            <?php endif; ?>
            <?php if(session('error')): ?>
                toastr.error("<?php echo e(session('error')); ?>");
            <?php endif; ?>
        });
    </script>

</body>
</html><?php /**PATH /home/khelawin124/trustwallet.dpdns.org/resources/views/app/main/withdraw/index.blade.php ENDPATH**/ ?>