<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Bank Account - <?php echo e(env('APP_NAME')); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <link rel="icon" type="image/jpg" href="<?php echo e(asset('static/images/logo.jpg')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <style>
        :root {
            --brand-primary: #e60012;
            --brand-dark: #b3000e;
            --text-muted: #6b7280;
            --card-shadow: 0 8px 25px rgba(179, 0, 14, 0.08);
            --success-color: #10b981;
            --failed-color: #ef4444;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e7e9ef 100%);
            min-height: 100vh;
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif;
            -webkit-font-smoothing: antialiased;
            position: relative;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 280px;
            background: linear-gradient(135deg, var(--brand-primary) 0%, var(--brand-dark) 100%);
            z-index: 0;
        }

        /* Header */
        .page-header {
            background: transparent;
            color: #fff;
            padding: 0 20px;
            height: 60px;
            font-size: 20px;
            font-weight: 700;
            position: relative;
            z-index: 1000;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .back-arrow {
            color: #fff;
            font-size: 22px;
            text-decoration: none;
            width: 32px;
            height: 32px;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            transition: all 0.3s ease;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
        }

        .back-arrow:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateX(-3px);
        }
        
        .header-placeholder {
            width: 32px;
        }

        .header-title {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .header-icon {
            width: 36px;
            height: 36px;
            background: rgba(255, 255, 255, 0.15);
            border-radius: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            backdrop-filter: blur(10px);
        }

        /* Main Content */
        .content-area {
            padding: 20px;
            position: relative;
            z-index: 1;
            max-width: 500px;
            margin: 0 auto;
        }

        /* Info Card */
        .info-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            padding: 24px;
            margin-bottom: 20px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
            border: 1px solid rgba(255, 255, 255, 0.8);
        }

        .info-header {
            display: flex;
            align-items: center;
            gap: 12px;
            margin-bottom: 12px;
        }

        .info-icon {
            width: 44px;
            height: 44px;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 20px;
            box-shadow: 0 4px 15px rgba(230, 0, 18, 0.3);
        }

        .info-title {
            font-size: 18px;
            font-weight: 700;
            color: #1f2937;
        }

        .info-subtitle {
            font-size: 13px;
            color: var(--text-muted);
            line-height: 1.6;
        }

        /* Form Card */
        .form-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.12);
            border: 1px solid rgba(255, 255, 255, 0.8);
            padding: 30px;
            position: relative;
            overflow: hidden;
        }

        .form-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--brand-primary), var(--brand-dark));
        }

        .form-group {
            margin-bottom: 24px;
            position: relative;
        }

        .form-label {
            font-weight: 600;
            color: #1f2937;
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 14px;
            margin-bottom: 10px;
            letter-spacing: 0.3px;
        }

        .form-label i {
            color: var(--brand-primary);
            font-size: 16px;
        }

        .form-input, .form-select {
            width: 100%;
            height: 54px;
            border: 2px solid #e5e7eb;
            border-radius: 14px;
            background: #ffffff;
            font-size: 15px;
            outline: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-sizing: border-box;
            padding: 0 18px;
            -webkit-appearance: none;
            -moz-appearance: none;
            appearance: none;
            font-weight: 500;
            color: #1f2937;
        }

        .form-input::placeholder {
            color: #9ca3af;
            font-weight: 400;
        }
        
        .select-wrapper {
            position: relative;
        }

        .select-wrapper::after {
            content: '\f078';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            right: 18px;
            top: 50%;
            transform: translateY(-50%);
            pointer-events: none;
            color: var(--brand-primary);
            font-size: 14px;
            transition: all 0.3s ease;
        }

        .select-wrapper:has(.form-select:focus)::after {
            transform: translateY(-50%) rotate(180deg);
        }

        .form-input:focus, .form-select:focus {
            border-color: var(--brand-primary);
            background: #ffffff;
            box-shadow: 0 0 0 4px rgba(230, 0, 18, 0.1);
            transform: translateY(-2px);
        }

        .form-input:hover, .form-select:hover {
            border-color: #fca5a5;
        }

        .btn-submit {
            width: 100%;
            height: 56px;
            font-size: 16px;
            font-weight: 700;
            color: #fff;
            background: linear-gradient(135deg, var(--brand-primary), var(--brand-dark));
            border: none;
            border-radius: 14px;
            cursor: pointer;
            margin-top: 16px;
            box-shadow: 0 8px 24px rgba(230, 0, 18, 0.3);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            letter-spacing: 0.5px;
        }

        .btn-submit::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
            transition: left 0.5s ease;
        }

        .btn-submit:hover::before {
            left: 100%;
        }

        .btn-submit:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 32px rgba(230, 0, 18, 0.4);
        }

        .btn-submit:active {
            transform: translateY(-1px);
        }

        .btn-submit i {
            margin-left: 8px;
            transition: transform 0.3s ease;
        }

        .btn-submit:hover i {
            transform: translateX(4px);
        }
        
        /* Toast Notification */
        #toast-bar {
            position: fixed;
            bottom: 30px;
            right: 30px;
            transform: translateX(120%);
            background-color: rgba(17, 24, 39, 0.95);
            backdrop-filter: blur(12px);
            color: white;
            padding: 16px 24px;
            border-radius: 14px;
            z-index: 9999;
            visibility: hidden;
            opacity: 0;
            font-size: 14px;
            font-weight: 600;
            box-shadow: 0 10px 40px rgba(0,0,0,0.3);
            max-width: 340px;
            transition: all 0.5s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            display: flex;
            align-items: center;
            gap: 12px;
        }

        #toast-bar::before {
            content: '\f00c';
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            width: 32px;
            height: 32px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 8px;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        #toast-bar.error::before {
            content: '\f06a';
        }

        #toast-bar.show {
            visibility: visible;
            opacity: 1;
            transform: translateX(0) scale(1);
        }

        /* Security Badge */
        .security-badge {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            margin-top: 24px;
            padding: 12px;
            background: rgba(16, 185, 129, 0.08);
            border-radius: 10px;
            font-size: 13px;
            color: #059669;
            font-weight: 600;
        }

        .security-badge i {
            font-size: 16px;
        }

        /* Responsive */
        @media (max-width: 480px) {
            .content-area {
                padding: 16px;
            }

            .form-card, .info-card {
                padding: 24px 20px;
            }

            #toast-bar {
                right: 20px;
                left: 20px;
                max-width: none;
                transform: translateY(120%);
                bottom: 20px;
            }

            #toast-bar.show {
                transform: translateY(0);
            }
        }

        /* Loading Animation */
        @keyframes pulse {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.5;
            }
        }

        .btn-submit:disabled {
            cursor: not-allowed;
            opacity: 0.7;
            animation: pulse 1.5s ease-in-out infinite;
        }
    </style>
</head>
<body>
    
    <!-- Header -->
    <div class="page-header">
        <a href="javascript:history.back()" class="back-arrow">
            <i class="fas fa-arrow-left"></i>
        </a>
        <div class="header-title">
            <div class="header-icon">
                <i class="fas fa-building-columns"></i>
            </div>
            <span>Bank Account</span>
        </div>
        <div class="header-placeholder"></div>
    </div>

    <main class="content-area">
        <!-- Info Card -->
        <div class="info-card">
            <div class="info-header">
                <div class="info-icon">
                    <i class="fas fa-info-circle"></i>
                </div>
                <div>
                    <div class="info-title">Payment Information</div>
                </div>
            </div>
            <div class="info-subtitle">
                Please provide your bank account details carefully. This information will be used for all your transactions and withdrawals.
            </div>
        </div>

        <!-- Form Card -->
        <div class="form-card">
            <?php echo $__env->make('alert-message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <form method="POST" action="<?php echo e(route('setup.gateway.submit')); ?>">
                <?php echo csrf_field(); ?>

                <!-- Bank Selection -->
                <div class="form-group">
                    <label class="form-label" for="gateway_method">
                        <i class="fas fa-university"></i>
                        Bank Name
                    </label>
                    <div class="select-wrapper">
                        <select id="gateway_method" name="gateway_method" required class="form-select">
                            <?php
                                $methods = class_exists('\App\Models\PaymentMethod') ? \App\Models\PaymentMethod::select('id','name')->where('status', 'active')->groupBy('name')->get() : [];
                            ?>
                            <option value="">Select your bank</option>
                            <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($element->id); ?>" <?php echo e((auth()->user()->gateway_method == $element->id) ? 'selected' : ''); ?>>
                                    <?php echo e($element->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <!-- Full Name -->
                <div class="form-group">
                    <label class="form-label" for="holdername">
                        <i class="fas fa-user"></i>
                        Account Holder Name
                    </label>
                    <input id="holdername" type="text" name="holdername" value="<?php echo e(auth()->user()->holder_name); ?>" maxlength="49" required placeholder="Enter full name as per bank records" class="form-input">
                </div>

                <!-- Account Number -->
                <div class="form-group">
                    <label class="form-label" for="gateway_number">
                        <i class="fas fa-hashtag"></i>
                        Account Number
                    </label>
                    <input id="gateway_number" type="text" name="gateway_number" value="<?php echo e(auth()->user()->gateway_number); ?>" maxlength="49" required placeholder="Enter your bank account number" class="form-input">
                </div>

                <!-- Submit Button -->
                <button class="btn-submit" type="submit">
                    Save Changes
                    <i class="fas fa-arrow-right"></i>
                </button>

                <!-- Security Badge -->
                <div class="security-badge">
                    <i class="fas fa-shield-check"></i>
                    Your information is encrypted and secure
                </div>
            </form>
        </div>
    </main>

    <div id="toast-bar"></div>

    <script>
        let toastTimeout;
        function showToast(message, isError = false) {
            const toastBar = document.getElementById('toast-bar');
            if (!toastBar) return;
            
            clearTimeout(toastTimeout);
            
            // Remove previous text content but keep the icon
            const textNode = document.createTextNode(message);
            toastBar.innerHTML = '';
            toastBar.appendChild(textNode);
            
            toastBar.style.backgroundColor = isError 
                ? 'rgba(239, 68, 68, 0.95)' 
                : 'rgba(16, 185, 129, 0.95)';
            
            if (isError) {
                toastBar.classList.add('error');
            } else {
                toastBar.classList.remove('error');
            }
            
            toastBar.classList.add('show');
            
            toastTimeout = setTimeout(() => {
                toastBar.classList.remove('show');
            }, 3500); 
        }

        document.addEventListener('DOMContentLoaded', function() {
            <?php if(session('success')): ?>
                showToast("<?php echo e(session('success')); ?>");
            <?php endif; ?>
            <?php if(session('error')): ?>
                showToast("<?php echo e(session('error')); ?>", true);
            <?php endif; ?>
        });
    </script>
</body>
</html><?php /**PATH /home/khelawin124/trustwallet.dpdns.org/resources/views/app/main/add_bank.blade.php ENDPATH**/ ?>